<?php
// get_conversations.php - مع بيانات VIP كاملة
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$userId = $_GET['user_id'] ?? 0;
if (empty($userId)) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required.']));
}

try {
    $stmt = $conn->prepare("
        SELECT
            p.id                    AS partner_id,
            p.display_name          AS partner_name,
            p.profile_image_url     AS partner_image_url,
            p.name_color            AS partner_name_color,
            p.font_identifier       AS partner_font_identifier,
            p.frame_identifier      AS partner_frame_identifier,
            p.is_verified           AS partner_is_verified,
            p.vip_tier              AS vip_tier,
            p.vip_expires_at        AS vip_expires_at,
            p.vip_gif_url           AS vip_gif_url,
            m.message_text          AS last_message,
            m.timestamp             AS last_message_timestamp,
            (SELECT COUNT(*)
             FROM messages unread
             WHERE unread.sender_id    = p.id
               AND unread.recipient_id = :user_id
               AND unread.is_read      = 0) AS unread_count
        FROM messages m
        JOIN (
            SELECT
                LEAST(sender_id, recipient_id)    AS user1,
                GREATEST(sender_id, recipient_id) AS user2,
                MAX(id)                           AS max_message_id
            FROM messages
            WHERE :user_id IN (sender_id, recipient_id)
            GROUP BY user1, user2
        ) latest ON m.id = latest.max_message_id
        JOIN users p ON p.id = IF(latest.user1 = :user_id, latest.user2, latest.user1)
        ORDER BY m.timestamp DESC
    ");

    $stmt->execute([':user_id' => $userId]);
    $conversations = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $now = time();
    $conversations = array_map(function($convo) use ($now) {
        $convo['partner_is_verified'] = (bool)$convo['partner_is_verified'];

        // ★ حساب VIP
        $vipTier    = $convo['vip_tier']       ?? 'none';
        $vipExpires = $convo['vip_expires_at'];
        $vipIsActive = ($vipTier !== 'none')
            && ($vipExpires === null || strtotime($vipExpires) > $now);

        $convo['vip_tier']      = $vipIsActive ? $vipTier : 'none';
        $convo['vip_is_active'] = $vipIsActive;

        // ★ vip_gif_url للمستخدم الذهبي فقط
        $convo['vip_gif_url'] = ($vipIsActive && $vipTier === 'gold' && !empty($convo['vip_gif_url']))
            ? $convo['vip_gif_url']
            : null;

        unset($convo['vip_expires_at']);

        return $convo;
    }, $conversations);

    echo json_encode([
        'status' => 'success',
        'data'   => $conversations
    ]);

} catch (Exception $e) {
    http_response_code(500);
    error_log("Get Conversations Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم: ' . $e->getMessage()]);
}
?>