<?php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

try {
    $stmt = $conn->query("SELECT id, name, description, image_url, max_members, created_at FROM chat_rooms ORDER BY created_at DESC");
    $rooms = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $result = [];
    foreach ($rooms as $room) {
        $stmt_count = $conn->prepare("SELECT COUNT(*) as count FROM room_members WHERE room_id = :room_id");
        $stmt_count->execute([':room_id' => $room['id']]);
        $count = $stmt_count->fetch()['count'];
        
        $result[] = [
            'id' => (int)$room['id'],
            'name' => $room['name'],
            'description' => $room['description'],
            'image_url' => $room['image_url'],
            'max_members' => (int)$room['max_members'],
            'current_members' => (int)$count,
            'created_at' => $room['created_at']
        ];
    }
    
    echo json_encode(['status' => 'success', 'rooms' => $result]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>