<?php
// get_blocked_users.php

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

// نستخدم GET لأننا نجلب بيانات فقط
$blockerId = $_GET['user_id'] ?? 0;

if (empty($blockerId)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'معرف المستخدم (الحاظر) مطلوب.']));
}

try {
    // هذا الاستعلام المعقد يقوم بالآتي:
    // 1. يختار من جدول blocked_users كل الصفوف التي يكون فيها blocker_id هو المستخدم الحالي.
    // 2. يقوم بعمل JOIN مع جدول users لجلب بيانات المستخدم المحظور (اسمه وصورته).
    $stmt = $conn->prepare(
        "SELECT 
            u.id AS blocked_user_id,
            u.username,
            u.profile_image_url
         FROM blocked_users bu
         JOIN users u ON bu.blocked_id = u.id
         WHERE bu.blocker_id = :blocker_id
         ORDER BY u.username ASC"
    );

    $stmt->execute([':blocker_id' => $blockerId]);

    $blockedUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'status' => 'success',
        'data' => $blockedUsers
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    error_log("Get Blocked Users Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم أثناء جلب قائمة المحظورين.']);
}
?>
