<?php
// get_all_requests.php (v1.2 - مع هيكل JSON ثابت)

ini_set('display_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);
$user_id = $data['user_id'] ?? 0;

if (empty($user_id)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required.']));
}

try {
    $all_requests = [];

    // 1. جلب طلبات الارتباط المعلقة
    $stmt_conn = $conn->prepare(
        "SELECT 
            cr.id as request_id, 
            u.id as user_id,
            u.display_name as user_name,
            u.profile_image_url as user_image,
            'connection' as request_type,
            cr.created_at
        FROM connection_requests cr 
        JOIN users u ON cr.requester_id = u.id
        WHERE cr.recipient_id = :user_id AND cr.status = 'pending'"
    );
    $stmt_conn->execute([':user_id' => $user_id]);
    $connection_requests = $stmt_conn->fetchAll(PDO::FETCH_ASSOC);
    if ($connection_requests) {
        $all_requests = array_merge($all_requests, $connection_requests);
    }

    // 2. جلب طلبات المراسلة المعلقة
    $stmt_msg = $conn->prepare(
        "SELECT 
            m.sender_id as request_id,
            u.id as user_id,
            u.display_name as user_name,
            u.profile_image_url as user_image,
            m.message_text as first_message,
            'message' as request_type,
            m.timestamp as created_at
        FROM messages m
        JOIN users u ON m.sender_id = u.id
        WHERE m.recipient_id = :user_id AND m.status = 'request'
        GROUP BY m.sender_id
    ");
    $stmt_msg->execute([':user_id' => $user_id]);
    $message_requests = $stmt_msg->fetchAll(PDO::FETCH_ASSOC);
    if ($message_requests) {
        $all_requests = array_merge($all_requests, $message_requests);
    }

    // 3. ترتيب كل الطلبات حسب تاريخ الإنشاء (الأحدث أولاً)
    if (!empty($all_requests)) {
        usort($all_requests, function($a, $b) {
            return strtotime($b['created_at']) - strtotime($a['created_at']);
        });
    }
    
    // ★★★★★   بداية التعديل الرئيسي   ★★★★★
    // دائماً قم بإرسال كائن JSON يحتوي على status و data
    // حتى لو كانت مصفوفة data فارغة.
    echo json_encode([
        'status' => 'success',
        'data' => $all_requests
    ]);
    // ★★★★★    نهاية التعديل الرئيسي    ★★★★★

} catch (Exception $e) {
    http_response_code(500 );
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
