<?php
// fcm_sender.php (Fixed Version)

function get_google_api_access_token() {
    $private_key_pem = "-----BEGIN PRIVATE KEY-----\n" .
    "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCztW431tOFhOyI\n" .
    "1TJjKeJKVYaFtHCoXsXwsRPwStxvrQihKHVMaNQTc20XMQW8gAXhWVl6FCBAWtky\n" .
    "UbnQGEg8QK1eU+mK1XvzjylgfLzj0ASUaepDKeI97P80lgaw2T4hELAIh+CO5sKu\n" .
    "oYVpnWxevcZuVPDgz+hSdzRtW+o8BaWVn/41xWcjmFaMayBVrRoGrbtgyeyQPXLj\n" .
    "HJihvm+n2YL4kd/FA+z26/6KTCRgaUqkX/Wjr0Xyxd5lcmZBlHvLuS3N/VjMLwIJ\n" .
    "8TMEo4TO5YU4vhFc2LlWNLbBAin9D7oQcHK1nEuQl3oeLAt6zJORdjBD6lqROIyX\n" .
    "+h9iGlVLAgMBAAECggEAATbAkOKhAcamlF7xv8cXPXGSuNGqbg3PpgSEMKTUcbfC\n" .
    "c3si+vi9ZCtVp+YJ06dcFywWvgvEql2HGII8W/C2DJBSu3hWFnc2+CuzEeVeh/3F\n" .
    "lQ6DXf0L8CGZpPr4ct9FhEzXmhrJOKmGGiAlorCWZPH68jJ6mA3LGf1RgZE8mgjn\n" .
    "6FqNkX4Ih2/oJKlo9fqLqzerkj4zceeoAAouZZIg6uM4lSOF4w2bqykDeq6OVvpG\n" .
    "8it+0asrFhCRsJhb0Qfm//+/lVmekMAH2TLS3kmju8KveDsjwX79na61wFNuhZKe\n" .
    "Qa2lLSK1HWmK/5PDtw191qRgOi4ijXP+Pm47bIk7gQKBgQDt0Ggf0ILpPzJA1Lsk\n" .
    "6UZ9qDNDaQlfDXWn6XXQaY4QLAOgxsZnRJetwJk0X/PLVTEOVDO2FUCM6byDXYjL\n" .
    "K9xF5cZHV1tmDNG79kH3Dm03ZrAp8371LgOQPjtQq9nh4G98erUZlCq0yUPEiTh9\n" .
    "7GT92Qktds4JMoiLoEzgM5YIywKBgQDBc4SC64yNtQrF7QstKyD4+v/3X715SclL\n" .
    "I0nzPEZhk8fj7n52xnpkW2L0MF7asYr5yZiG6DTuGoF+USTM7z3beoghk4+6cHoU\n" .
    "L1EXaY0CBhppYcGaCn6CazEBfc0u9Bc7LdqAm46fJa55ZWfUysT2nMfF/tGBKNp/\n" .
    "5PmWN63VgQKBgQCtk0GMhwol6GRrgVme1U0IBi50c0PNxusrRXEiTwjLsPRs8uh5\n" .
    "E02KGls4KRiuPl3x0W905QoaT7eyQiDH+hlqQw13oMErOQwUHueCxVrd5uuJkxoF\n" .
    "JjKfo2xzsxryjHeS6ZUpOEX7cjMuTeGXt2T3CuRx9Jbpi6KyFqxFsCFABQKBgF8f\n" .
    "DxxU+FLBn599FE7MczUaLnyTrhYSixEQNA+PJshaIyLXpYV/yLTKHtkVY77DKCP0\n" .
    "1bQYP9aIX/4dpivCw7bFBGUGKtkw70Y3kfciJnzFRX1l3Q2CdXxperpSAm9BBJ9L\n" .
    "x7IPS0zD+Yulqi1+2uSsaKrZxmhtDytuCq+rhyWBAoGAFzHTW3L8skBiLfmoFQ36\n" .
    "5CoOpblHIXoKp7Ctl6ARrID1W/HzU0SA6jUyIQg69B7bpeic7GJcyxaBSg57w/Ri\n" .
    "KsOPj2nJ0J/xbULrbbzXkE0yoUU4dUMSxCbE24idRVaBZVUbQti6ABgH0NyfHpz2\n" .
    "8tvJUtYUcbdMaocWK5FD0Pw=\n" .
    "-----END PRIVATE KEY-----";
    
    $client_email = "firebase-adminsdk-fbsvc@couple-d1a57.iam.gserviceaccount.com";
    $token_uri = "https://oauth2.googleapis.com/token";

    $header = rtrim(strtr(base64_encode(json_encode(['alg' => 'RS256', 'typ' => 'JWT'])), '+/', '-_'), '=');
    
    $now = time();
    $payload = rtrim(strtr(base64_encode(json_encode([
        'iss' => $client_email,
        'scope' => 'https://www.googleapis.com/auth/cloud-platform',
        'aud' => $token_uri,
        'exp' => $now + 3600,
        'iat' => $now
    ])), '+/', '-_'), '=');

    $signature = '';
    openssl_sign("$header.$payload", $signature, $private_key_pem, 'sha256');
    $jwt = "$header.$payload." . rtrim(strtr(base64_encode($signature), '+/', '-_'), '=');

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $token_uri);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    return $data['access_token'] ?? null;
}

// ★★★ الدالة المُحسّنة - تدعم $conn أو $userId ★★★
function sendFcmNotification($conn_or_userId, $userId_or_title, $title_or_body, $body_or_data, $data = null) {
    // التحقق من نوع الاستدعاء
    if ($conn_or_userId instanceof PDO) {
        // الاستدعاء الجديد: ($conn, $userId, $title, $body, $data)
        $conn = $conn_or_userId;
        $userId = $userId_or_title;
        $title = $title_or_body;
        $body = $body_or_data;
        $data_payload = $data ?? [];
        
        // جلب FCM token من قاعدة البيانات
        try {
            $stmt = $conn->prepare("SELECT fcm_token FROM users WHERE id = :userId");
            $stmt->execute(['userId' => $userId]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            $target = $user['fcm_token'] ?? null;
            
            if (!$target) {
                error_log("No FCM token for user ID: $userId");
                return false;
            }
        } catch (Exception $e) {
            error_log("Error fetching FCM token: " . $e->getMessage());
            return false;
        }
    } else {
        // الاستدعاء القديم: ($target, $title, $body, $data_payload)
        $target = $conn_or_userId;
        $title = $userId_or_title;
        $body = $title_or_body;
        $data_payload = $body_or_data ?? [];
    }
    
    // الحصول على Access Token
    $access_token = get_google_api_access_token();
    if (!$access_token) {
        error_log("Failed to get FCM access token");
        return false;
    }

    $fcm_url = "https://fcm.googleapis.com/v1/projects/couple-d1a57/messages:send";

    // دمج العنوان والنص مع data payload
    if ($title) $data_payload['title'] = $title;
    if ($body) $data_payload['body'] = $body;

    // تحديد نوع الهدف (topic أو token)
    $target_field = (strpos($target, '/topics/') === 0) ? 'topic' : 'token';

    $message = [
        'message' => [
            $target_field => $target,
            'data' => $data_payload 
        ]
    ];

    $headers = [
        'Authorization: Bearer ' . $access_token,
        'Content-Type: application/json'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $fcm_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code !== 200) {
        error_log("FCM Error: HTTP $http_code - Response: $response");
        return false;
    }
    
    return true;
}