<?php
// ---------------------------------------------------------------------
// 1. إعدادات أولية وإخفاء الأخطاء
// ---------------------------------------------------------------------
// هذا السطر ضروري جداً لمنع طباعة أي أخطاء PHP تفسد استجابة الـ JSON
error_reporting(0);
ini_set('display_errors', 0);

// نحدد أن الاستجابة ستكون دائماً من نوع JSON
header('Content-Type: application/json; charset=utf-8');

// ---------------------------------------------------------------------
// 2. الاتصال بقاعدة البيانات (باستخدام بياناتك)
// ---------------------------------------------------------------------
$servername = "localhost";
$dbname = "u323701002_coc";
$username = "u323701002_us_coc";
$password = "AS_05344465928pr";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8mb4", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    // في حال فشل الاتصال، أرجع خطأ JSON واضح
    http_response_code(500 );
    echo json_encode(['status' => 'error', 'message' => 'فشل الاتصال بقاعدة البيانات']);
    exit();
}

// ---------------------------------------------------------------------
// 3. معالجة الطلب
// ---------------------------------------------------------------------
// التأكد من أن الطلب هو من نوع POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405 ); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'طريقة الطلب غير صالحة']);
    exit();
}

// قراءة البيانات القادمة من التطبيق (user_id)
$input = json_decode(file_get_contents('php://input'), true);
$user_id = isset($input['user_id']) ? (int)$input['user_id'] : 0;

// التحقق من وجود user_id صالح
if ($user_id <= 0) {
    http_response_code(400 ); // Bad Request
    echo json_encode(['status' => 'error', 'message' => 'معرّف المستخدم غير صالح']);
    exit();
}

try {
    // ---------------------------------------------------------------------
    // 4. حذف الصورة والبيانات
    // ---------------------------------------------------------------------

    // أولاً: جلب مسار الصورة الحالي من قاعدة البيانات قبل حذفه
    $stmt = $conn->prepare("SELECT profile_image_url FROM users WHERE id = :user_id");
    $stmt->execute([':user_id' => $user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // إذا كان المستخدم موجوداً ولديه صورة
    if ($user && !empty($user['profile_image_url'])) {
        $imageUrl = $user['profile_image_url'];

        // ثانياً: تحديث قاعدة البيانات وجعل حقل الصورة فارغاً (NULL)
        $updateStmt = $conn->prepare("UPDATE users SET profile_image_url = NULL WHERE id = :user_id");
        $updateStmt->execute([':user_id' => $user_id]);

        // ثالثاً: حذف ملف الصورة الفعلي من السيرفر
        // هذا الجزء يفترض أن مجلد الصور موجود في نفس مستوى ملفات الـ PHP
        // مثال: /public_html/Copel/uploads/image.jpg
        $basePath = $_SERVER['DOCUMENT_ROOT'] . '/Copel/';
        $filePath = str_replace('https://latrotech.online/Copel/', $basePath, $imageUrl );

        if (file_exists($filePath) && is_file($filePath)) {
            unlink($filePath);
        }
        
        // أخيراً: إرسال رسالة نجاح
        echo json_encode(['status' => 'success', 'message' => 'تم حذف الصورة بنجاح']);

    } else {
        // إذا لم يكن هناك صورة أصلاً، نعتبرها عملية ناجحة
        echo json_encode(['status' => 'success', 'message' => 'لا توجد صورة ليتم حذفها']);
    }

} catch (PDOException $e) {
    // في حال حدوث أي خطأ أثناء العمليات على قاعدة البيانات
    http_response_code(500 );
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم: ' . $e->getMessage()]);
}

// إغلاق الاتصال
$conn = null;
?>
