<?php
// delete_memory.php
// هذا الملف مسؤول عن حذف ذكرى معينة من قاعدة البيانات.

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php'; // تأكد من أن هذا هو اسم ملف الاتصال الصحيح

// 1. قراءة البيانات من الطلب (يفترض أن تكون بصيغة JSON)
$data = json_decode(file_get_contents('php://input'), true);

// 2. التحقق من وجود 'memory_id' في البيانات المستقبلة
$memory_id = $data['memory_id'] ?? 0;
if (empty($memory_id)) {
    // إذا لم يتم إرسال المعرف، أرسل رسالة خطأ
    http_response_code(400 ); // Bad Request
    exit(json_encode(['status' => 'error', 'message' => 'Memory ID is required.']));
}

try {
    // 3. تجهيز وتنفيذ استعلام الحذف
    // استخدم $conn أو $pdo بناءً على اسم المتغير في ملف db_connect.php
    $stmt = $conn->prepare("DELETE FROM memories WHERE id = :memory_id");
    $stmt->execute([':memory_id' => $memory_id]);

    // 4. التحقق مما إذا كان قد تم حذف أي صف
    if ($stmt->rowCount() > 0) {
        // تم الحذف بنجاح
        echo json_encode(['status' => 'success', 'message' => 'Memory deleted successfully.']);
    } else {
        // لم يتم العثور على الذكرى (ربما تم حذفها بالفعل)
        http_response_code(404 ); // Not Found
        echo json_encode(['status' => 'error', 'message' => 'Memory not found or already deleted.']);
    }

} catch (PDOException $e) {
    // في حالة حدوث خطأ في قاعدة البيانات
    http_response_code(500 ); // Internal Server Error
    error_log('Delete Memory Error: ' . $e->getMessage()); // تسجيل الخطأ في سجلات الخادم
    echo json_encode(['status' => 'error', 'message' => 'A database error occurred.']);
}
?>
