<?php
// delete_conversation.php

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

// نستخدم POST لأن هذا الإجراء يقوم بتعديل (حذف) البيانات
$data = json_decode(file_get_contents('php://input'), true);

$userId = $data['user_id'] ?? 0;
$partnerId = $data['partner_id'] ?? 0;

if (empty($userId) || empty($partnerId)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'معرفات المستخدمين مطلوبة لحذف المحادثة.']));
}

try {
    // هذا الاستعلام يحذف جميع الرسائل في كلا الاتجاهين
    // (من المستخدم إلى الشريك) و (من الشريك إلى المستخدم)
    $stmt = $conn->prepare(
        "DELETE FROM messages 
         WHERE (sender_id = :user_id AND recipient_id = :partner_id) 
            OR (sender_id = :partner_id AND recipient_id = :user_id)"
    );

    $stmt->execute([
        ':user_id' => $userId,
        ':partner_id' => $partnerId
    ]);

    //rowCount()  يعيد عدد الصفوف التي تم حذفها
    $deletedCount = $stmt->rowCount();

    echo json_encode([
        'status' => 'success',
        'message' => "تم حذف المحادثة بنجاح. (" . $deletedCount . " رسالة)"
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    error_log("Delete Conversation Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم أثناء حذف المحادثة.']);
}
?>
