<?php
// ---------------------------------------------------------------------
// delete_account.php (v3 - Full Data Deletion)
// ---------------------------------------------------------------------
// هذا الملف يقوم بحذف كامل وشامل لجميع بيانات المستخدم.

// 1. إعدادات أولية
// ---------------------------------------------------------------------
error_reporting(0);
ini_set('display_errors', 0);
header('Content-Type: application/json; charset=utf-8');

require 'db_connect.php'; // يفترض أن هذا الملف يحتوي على كائن $conn

// 2. قراءة وتأكيد المدخلات
// ---------------------------------------------------------------------
$data = json_decode(file_get_contents('php://input'), true);
$userId = isset($data['user_id']) ? (int)$data['user_id'] : 0;

if ($userId <= 0) {
    http_response_code(400 );
    echo json_encode(['status' => 'error', 'message' => 'معرف المستخدم غير صالح.']);
    exit();
}

// ---------------------------------------------------------------------
// 3. بدء المعاملة (Transaction) لضمان تنفيذ جميع الخطوات أو لا شيء
// ---------------------------------------------------------------------
$conn->beginTransaction();

try {
    // ---------------------------------------------------------------------
    // 4. جلب جميع البيانات الهامة للمستخدم قبل الحذف
    // ---------------------------------------------------------------------
    $stmt = $conn->prepare(
       "SELECT 
            u.couple_id,
            u.profile_image_url,
            u.google_id,
            p.id as partner_id, 
            p.fcm_token as partner_token 
        FROM users u
        LEFT JOIN couples c ON u.couple_id = c.id
        LEFT JOIN users p ON (c.user1_id = p.id OR c.user2_id = p.id) AND p.id != u.id
        WHERE u.id = :userId"
    );
    $stmt->execute([':userId' => $userId]);
    $userData = $stmt->fetch(PDO::FETCH_ASSOC);

    // إذا لم يتم العثور على المستخدم، فهذا يعني أنه قد تم حذفه بالفعل
    if (!$userData) {
        $conn->rollBack();
        echo json_encode(['status' => 'success', 'message' => 'الحساب غير موجود بالفعل.']);
        exit();
    }

    $coupleId = $userData['couple_id'] ?? null;
    $partnerId = $userData['partner_id'] ?? null;
    $partnerToken = $userData['partner_token'] ?? null;
    $imageUrl = $userData['profile_image_url'] ?? null;

    // ---------------------------------------------------------------------
    // 5. حذف ملف الصورة الشخصية من السيرفر (إن وجد)
    // ---------------------------------------------------------------------
    if (!empty($imageUrl)) {
        // يفترض أن مجلد الرفع موجود في نفس مستوى هذا السكريبت
        // مثال: /public_html/Copel/uploads/image.jpg
        $basePath = $_SERVER['DOCUMENT_ROOT'] . '/Copel/';
        $filePath = str_replace('https://latrotech.online/Copel/', $basePath, $imageUrl );
        
        if (file_exists($filePath) && is_file($filePath)) {
            @unlink($filePath); // @ لإخفاء أي خطأ إذا فشل الحذف لأي سبب
        }
    }

    // ---------------------------------------------------------------------
    // 6. حذف جميع البيانات المشتركة إذا كان المستخدم مرتبطاً
    // ---------------------------------------------------------------------
    if ($coupleId) {
        // حذف الإشارات
        $conn->prepare("DELETE FROM signals WHERE couple_id = :coupleId")->execute([':coupleId' => $coupleId]);
        // حذف الرسائل
        $conn->prepare("DELETE FROM messages WHERE couple_id = :coupleId")->execute([':coupleId' => $coupleId]);
        // حذف الذكريات
        $conn->prepare("DELETE FROM memories WHERE couple_id = :coupleId")->execute([':coupleId' => $coupleId]);
        // حذف سجلات المواعيد الهامة
        $conn->prepare("DELETE FROM milestones WHERE couple_id = :coupleId")->execute([':coupleId' => $coupleId]);
        
        // فك ارتباط الشريك (جعله حراً)
        if ($partnerId) {
            $conn->prepare("UPDATE users SET couple_id = NULL WHERE id = :partnerId")->execute([':partnerId' => $partnerId]);
        }
        
        // حذف سجل الارتباط نفسه
        $conn->prepare("DELETE FROM couples WHERE id = :coupleId")->execute([':coupleId' => $coupleId]);
    }

    // ---------------------------------------------------------------------
    // 7. حذف البيانات الخاصة بالمستخدم فقط
    // ---------------------------------------------------------------------
    // حذف سجلات الحظر (سواء كان هو الحاجب أو المحظور)
    $conn->prepare("DELETE FROM blocked_users WHERE blocker_id = :userId OR blocked_id = :userId")->execute([':userId' => $userId]);
    
    // حذف طلبات الارتباط المعلقة
    $conn->prepare("DELETE FROM connection_requests WHERE requester_id = :userId OR recipient_id = :userId")->execute([':userId' => $userId]);

    // ---------------------------------------------------------------------
    // 8. حذف المستخدم نفسه من الجدول الرئيسي
    // ---------------------------------------------------------------------
    $conn->prepare("DELETE FROM users WHERE id = :userId")->execute([':userId' => $userId]);

    // ---------------------------------------------------------------------
    // 9. إتمام المعاملة بنجاح
    // ---------------------------------------------------------------------
    $conn->commit();

    // ---------------------------------------------------------------------
    // 10. إرسال رد ناجح للتطبيق
    // ---------------------------------------------------------------------
    echo json_encode([
        'status' => 'success', 
        'message' => 'تم حذف حسابك وجميع بياناتك بنجاح.',
        'data' => [
            'partner_token' => $partnerToken // إرسال التوكن للتطبيق لإعلام الشريك
        ]
    ]);

} catch (PDOException $e) {
    // في حال حدوث أي خطأ، يتم التراجع عن جميع التغييرات
    $conn->rollBack();
    // تسجيل الخطأ في سجلات الخادم للمراجعة لاحقاً
    error_log("Delete account failed for user $userId: " . $e->getMessage());
    http_response_code(500 );
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ فادح أثناء حذف الحساب.']);
}

// إغلاق الاتصال
$conn = null;
?>
