<?php
/**
 * debug_visits.php
 * ارفع هذا الملف على السيرفر في نفس مجلد باقي الـ PHP files
 * ثم افتحه من المتصفح: https://latrotech.online/Copel/debug_visits.php?visitor=1&visited=2
 * غيّر الأرقام لأي مستخدمين موجودين عندك
 */

header('Content-Type: text/html; charset=utf-8');
require 'db_connect.php';

$visitor_id = isset($_GET['visitor']) ? intval($_GET['visitor']) : 0;
$visited_id = isset($_GET['visited']) ? intval($_GET['visited']) : 0;

echo "<h2>🔍 تشخيص نظام الزيارات</h2>";
echo "<p>visitor_id = <b>$visitor_id</b> | visited_id = <b>$visited_id</b></p>";
echo "<hr>";

// ══════════════════════════════════════════
// 1. التحقق من وجود جدول profile_visits
// ══════════════════════════════════════════
echo "<h3>1. هل جدول profile_visits موجود؟</h3>";
try {
    $stmt = $conn->query("SHOW TABLES LIKE 'profile_visits'");
    if ($stmt->rowCount() > 0) {
        echo "✅ الجدول موجود<br>";

        // اعرض بنية الجدول
        $cols = $conn->query("DESCRIBE profile_visits");
        echo "<table border='1' cellpadding='5'><tr><th>Column</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        foreach ($cols->fetchAll(PDO::FETCH_ASSOC) as $col) {
            echo "<tr><td>{$col['Field']}</td><td>{$col['Type']}</td><td>{$col['Null']}</td><td>{$col['Key']}</td><td>{$col['Default']}</td></tr>";
        }
        echo "</table><br>";
    } else {
        echo "❌ <b>الجدول غير موجود!</b> هذا هو السبب الرئيسي.<br>";
        echo "<b>الحل: نفّذ هذا SQL:</b><br>";
        echo "<pre style='background:#f0f0f0;padding:10px'>
CREATE TABLE IF NOT EXISTS profile_visits (
    id INT AUTO_INCREMENT PRIMARY KEY,
    visitor_id INT NOT NULL,
    visited_id INT NOT NULL,
    visit_timestamp DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_visited (visited_id),
    INDEX idx_visitor (visitor_id),
    INDEX idx_timestamp (visit_timestamp)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        </pre>";
    }
} catch (Exception $e) {
    echo "❌ خطأ: " . $e->getMessage() . "<br>";
}

// ══════════════════════════════════════════
// 2. التحقق من وجود المستخدمين
// ══════════════════════════════════════════
echo "<hr><h3>2. هل المستخدمان موجودان في جدول users؟</h3>";
if ($visitor_id > 0 && $visited_id > 0) {
    try {
        $stmt = $conn->prepare("SELECT id, display_name FROM users WHERE id IN (:v1, :v2)");
        $stmt->execute([':v1' => $visitor_id, ':v2' => $visited_id]);
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($users) == 0) {
            echo "❌ <b>لا يوجد أي مستخدم بهذه الـ IDs!</b><br>";
        } else {
            foreach ($users as $u) {
                echo "✅ مستخدم موجود: ID={$u['id']} الاسم={$u['display_name']}<br>";
            }
            if (count($users) < 2) {
                echo "⚠️ <b>أحد المستخدمين غير موجود!</b><br>";
            }
        }
    } catch (Exception $e) {
        echo "❌ خطأ: " . $e->getMessage() . "<br>";
    }
} else {
    echo "⚠️ أضف ?visitor=X&visited=Y في الرابط<br>";
}

// ══════════════════════════════════════════
// 3. محاولة تسجيل زيارة مباشرة
// ══════════════════════════════════════════
echo "<hr><h3>3. محاولة INSERT مباشر في الجدول</h3>";
if ($visitor_id > 0 && $visited_id > 0 && $visitor_id !== $visited_id) {
    try {
        $stmt = $conn->prepare(
            "INSERT INTO profile_visits (visitor_id, visited_id, visit_timestamp)
             VALUES (:visitor_id, :visited_id, CURRENT_TIMESTAMP)"
        );
        $stmt->execute([':visitor_id' => $visitor_id, ':visited_id' => $visited_id]);
        $insertId = $conn->lastInsertId();
        echo "✅ <b>تم الإدراج بنجاح!</b> ID الجديد = $insertId<br>";
        echo "👉 إذا وصلت لهنا، مشكلتك في الكود Java وليس في الـ PHP/DB<br>";
    } catch (Exception $e) {
        echo "❌ <b>فشل INSERT:</b> " . $e->getMessage() . "<br>";

        // تحليل الخطأ
        $msg = $e->getMessage();
        if (strpos($msg, 'foreign key') !== false) {
            echo "💡 السبب: <b>Foreign Key Constraint</b> — جدول profile_visits مرتبط بجدول users بـ FK.<br>";
            echo "الحل: تأكد أن IDs موجودة في جدول users<br>";
        } elseif (strpos($msg, "doesn't exist") !== false) {
            echo "💡 السبب: <b>الجدول غير موجود</b><br>";
        } elseif (strpos($msg, 'Duplicate') !== false) {
            echo "💡 السبب: <b>Unique Key</b> يمنع التكرار — ربما عندك UNIQUE على (visitor_id, visited_id)<br>";
            echo "الحل: احذف الـ UNIQUE constraint أو استخدم INSERT ON DUPLICATE KEY UPDATE<br>";
        }
    }
} else {
    echo "⚠️ تخطّيت هذا الاختبار (IDs غير صالحة أو متطابقة)<br>";
}

// ══════════════════════════════════════════
// 4. عرض آخر 5 زيارات في الجدول
// ══════════════════════════════════════════
echo "<hr><h3>4. آخر 5 زيارات في الجدول</h3>";
try {
    $stmt = $conn->query("SELECT * FROM profile_visits ORDER BY visit_timestamp DESC LIMIT 5");
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (empty($rows)) {
        echo "📭 الجدول فارغ — لم تُسجَّل أي زيارة حتى الآن<br>";
    } else {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>id</th><th>visitor_id</th><th>visited_id</th><th>visit_timestamp</th></tr>";
        foreach ($rows as $row) {
            echo "<tr><td>{$row['id']}</td><td>{$row['visitor_id']}</td><td>{$row['visited_id']}</td><td>{$row['visit_timestamp']}</td></tr>";
        }
        echo "</table>";
    }
} catch (Exception $e) {
    echo "❌ " . $e->getMessage() . "<br>";
}

// ══════════════════════════════════════════
// 5. اختبار record_profile_visit.php مباشرة
// ══════════════════════════════════════════
echo "<hr><h3>5. اختبار record_profile_visit.php مباشرة عبر curl</h3>";
if ($visitor_id > 0 && $visited_id > 0) {
    $payload = json_encode(['visitor_id' => $visitor_id, 'visited_id' => $visited_id]);
    $url = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/record_profile_visit.php';

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);

    echo "URL المُختبَر: <code>$url</code><br>";
    echo "HTTP Code: <b>$httpCode</b><br>";
    if ($curlError) {
        echo "❌ Curl Error: $curlError<br>";
    } else {
        echo "Response: <pre style='background:#f0f0f0;padding:10px'>$response</pre>";
        $decoded = json_decode($response, true);
        if (isset($decoded['status'])) {
            if ($decoded['status'] === 'success') {
                echo "✅ <b>record_profile_visit.php يعمل بشكل صحيح!</b><br>";
                echo "👉 المشكلة في الكود Java — تحقق من Logcat<br>";
            } else {
                echo "❌ <b>record_profile_visit.php يرجع خطأ:</b> " . ($decoded['message'] ?? 'unknown') . "<br>";
            }
        }
    }
} else {
    echo "⚠️ أضف ?visitor=X&visited=Y في الرابط<br>";
}

echo "<hr><p style='color:gray'>انتهى التشخيص — احذف هذا الملف من السيرفر بعد الانتهاء!</p>";
?>