<?php
// cron_cleanup_expired_questions.php
// يتم تشغيله كل 5 دقائق عبر Cron Job لحذف الأسئلة المنتهية

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';
require 'fcm_sender.php';
require_once __DIR__ . '/PusherHelper.php';

try {
    $conn->beginTransaction();
    
    // جلب جميع الأسئلة المنتهية الصلاحية
    $stmt_expired = $conn->prepare(
        "SELECT tgr.*, tg.couple_id 
         FROM truth_game_rounds tgr
         JOIN truth_games tg ON tgr.game_id = tg.id
         WHERE tgr.answer_text IS NULL 
         AND tgr.expires_at < NOW()"
    );
    $stmt_expired->execute();
    $expired_rounds = $stmt_expired->fetchAll(PDO::FETCH_ASSOC);
    
    $deleted_count = 0;
    $processed_games = [];
    
    foreach ($expired_rounds as $round) {
        error_log("Cron: Auto-deleting expired round ID: " . $round['id']);
        
        // حذف السؤال المنتهي
        $stmt_delete = $conn->prepare("DELETE FROM truth_game_rounds WHERE id = :round_id");
        $stmt_delete->execute([':round_id' => $round['id']]);
        $deleted_count++;
        
        // تحديث الدور لكل لعبة مرة واحدة فقط
        if (!in_array($round['game_id'], $processed_games)) {
            $processed_games[] = $round['game_id'];
            
            // جلب معلومات الزوجين
            $stmt_couple = $conn->prepare("SELECT user1_id, user2_id FROM couples WHERE id = :couple_id");
            $stmt_couple->execute([':couple_id' => $round['couple_id']]);
            $couple_data = $stmt_couple->fetch(PDO::FETCH_ASSOC);
            
            if ($couple_data) {
                // تحديد من كان يجب أن يجيب
                $answer_user_id = ($round['question_user_id'] == $couple_data['user1_id']) 
                    ? $couple_data['user2_id'] 
                    : $couple_data['user1_id'];
                
                // تحديث الدور
                $stmt_turn = $conn->prepare("UPDATE truth_games SET current_turn_user_id = :turn_id WHERE id = :game_id");
                $stmt_turn->execute([
                    ':turn_id' => $answer_user_id,
                    ':game_id' => $round['game_id']
                ]);
                
                // جلب أسماء المستخدمين
                $stmt_names = $conn->prepare("SELECT id, display_name FROM users WHERE id IN (:id1, :id2)");
                $stmt_names->execute([':id1' => $round['question_user_id'], ':id2' => $answer_user_id]);
                $users = $stmt_names->fetchAll(PDO::FETCH_KEY_PAIR);
                
                $skipped_user_name = $users[$answer_user_id] ?? 'شريكك';
                $asker_name = $users[$round['question_user_id']] ?? 'اللاعب';
                
                $message = "انتهى الوقت! لم يقم $skipped_user_name بالإجابة على سؤال $asker_name. الدور الآن على $skipped_user_name لطرح سؤال.";
                
                // إرسال FCM notifications
                sendFcmNotification($conn, $couple_data['user1_id'], "انتهى الوقت في لعبة الصراحة", $message, ['type' => 'truth-turn-skipped']);
                sendFcmNotification($conn, $couple_data['user2_id'], "انتهى الوقت في لعبة الصراحة", $message, ['type' => 'truth-turn-skipped']);
                
                // إرسال Pusher events
                $pusher_data = [
                    'round_id' => (int)$round['id'],
                    'next_turn_user_id' => (int)$answer_user_id,
                    'message' => $message
                ];
                
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1", 
                    "85330156aec9dd641145", 
                    "2109257", 
                    "mt1", 
                    'user-' . $couple_data['user1_id'], 
                    'truth-turn-skipped', 
                    $pusher_data
                );
                
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1", 
                    "85330156aec9dd641145", 
                    "2109257", 
                    "mt1", 
                    'user-' . $couple_data['user2_id'], 
                    'truth-turn-skipped', 
                    $pusher_data
                );
            }
        }
    }
    
    $conn->commit();
    
    echo json_encode([
        'status' => 'success',
        'message' => "Cleanup completed successfully.",
        'deleted_count' => $deleted_count,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    $conn->rollBack();
    error_log("Cron Cleanup Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>