<?php
/**
 * close_inactive_sessions.php
 * ===========================
 * يُشغَّل كل 5 دقائق عبر Cron Job
 * يفحص المستخدمين اللي انقطع heartbeat عندهم ويغلق جلستهم
 *
 * Cron Job:
 * هذا الأمر يشغله كل 5 دقائق - أضفه في لوحة cPanel أو crontab:
 * كل 5 دقائق: * /5 * * * * php /path/to/close_inactive_sessions.php
 *
 * @version 1.0
 * @date 2026-02-16
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

try {
    $conn = new mysqli("localhost", "u323701002_us_coc", "AS_05344465928pr", "u323701002_coc");

    if ($conn->connect_error) {
        throw new Exception('Database connection failed: ' . $conn->connect_error);
    }

    $conn->set_charset("utf8mb4");

    // ═══════════════════════════════════════════════════════
    // الخطوة 1: إيجاد الجلسات المفتوحة التي انقطع heartbeat
    //           عنها منذ أكثر من 3 دقائق (مرونة للتأخير)
    // ═══════════════════════════════════════════════════════
    $stmt = $conn->prepare("
        SELECT id, user_id, device_id, session_start, last_heartbeat
        FROM user_activity_sessions
        WHERE session_end IS NULL
          AND last_heartbeat < DATE_SUB(NOW(), INTERVAL 3 MINUTE)
    ");
    $stmt->execute();
    $result = $stmt->get_result();
    $inactive_sessions = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    $closed_count = 0;

    foreach ($inactive_sessions as $session) {
        $session_id  = $session['id'];
        $user_id     = $session['user_id'];

        // ═══════════════════════════════════════════════════
        // الخطوة 2: إغلاق الجلسة - نعتبر آخر heartbeat
        //           هو وقت الخروج الفعلي
        // ═══════════════════════════════════════════════════
        $stmt = $conn->prepare("
            UPDATE user_activity_sessions
            SET session_end      = last_heartbeat,
                duration_seconds = TIMESTAMPDIFF(SECOND, session_start, last_heartbeat)
            WHERE id = ?
              AND session_end IS NULL
        ");
        $stmt->bind_param("i", $session_id);
        $stmt->execute();
        $stmt->close();

        // ═══════════════════════════════════════════════════
        // الخطوة 3: تحديث حالة المستخدم إلى غير نشط
        // ═══════════════════════════════════════════════════
        $stmt = $conn->prepare("
            UPDATE users
            SET is_active   = 0,
                last_active = ?
            WHERE id = ?
              AND is_active = 1
        ");
        $stmt->bind_param("si", $session['last_heartbeat'], $user_id);
        $stmt->execute();
        $stmt->close();

        $closed_count++;
        error_log("[close_inactive_sessions] Closed session $session_id for user $user_id (last heartbeat: {$session['last_heartbeat']})");
    }

    error_log("[close_inactive_sessions] Done. Closed $closed_count inactive sessions.");
    echo json_encode([
        'status'        => 'success',
        'closed_count'  => $closed_count,
        'checked_at'    => date('Y-m-d H:i:s')
    ]);

    $conn->close();

} catch (Exception $e) {
    error_log("[close_inactive_sessions] Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>