<?php
/**
 * cleanup_old_logs.php
 * ====================
 * تنظيف السجلات القديمة من جدول daily_actions_log
 * 
 * يجب تشغيله يومياً عبر Cron Job
 * 
 * @version 1.0
 * @date 2026-02-05
 */

require 'db_connect.php';

// محاولة تحميل نظام النقاط v2
if (file_exists('points_manager_v2.php')) {
    require 'points_manager_v2.php';
}

// عدد الأيام للاحتفاظ بالسجلات (افتراضي: 30 يوم)
$daysToKeep = isset($argv[1]) ? (int)$argv[1] : 30;

try {
    echo "=== بدء تنظيف السجلات القديمة ===\n";
    echo "التاريخ: " . date('Y-m-d H:i:s') . "\n";
    echo "الاحتفاظ بآخر $daysToKeep يوم\n\n";
    
    // استخدام الدالة من points_manager_v2 إن وجدت
    if (function_exists('cleanupOldLogs')) {
        $result = cleanupOldLogs($conn, $daysToKeep);
        
        if ($result['status'] === 'success') {
            echo "✓ تم الحذف بنجاح\n";
            echo "عدد السجلات المحذوفة: " . $result['rows_deleted'] . "\n";
            
            // تسجيل في log file
            error_log(
                "[Cleanup] " . date('Y-m-d H:i:s') . 
                " - Deleted " . $result['rows_deleted'] . " old records"
            );
        } else {
            echo "✗ خطأ: " . $result['message'] . "\n";
            error_log("[Cleanup Error] " . $result['message']);
        }
    } else {
        // تنفيذ التنظيف مباشرة
        $stmt = $conn->prepare(
            "DELETE FROM daily_actions_log 
             WHERE action_date < DATE_SUB(NOW(), INTERVAL :days DAY)"
        );
        
        $stmt->execute([':days' => $daysToKeep]);
        $rowsDeleted = $stmt->rowCount();
        
        echo "✓ تم الحذف بنجاح\n";
        echo "عدد السجلات المحذوفة: $rowsDeleted\n";
        
        error_log(
            "[Cleanup] " . date('Y-m-d H:i:s') . 
            " - Deleted $rowsDeleted old records"
        );
    }
    
    // إحصائيات بعد التنظيف
    echo "\n=== إحصائيات بعد التنظيف ===\n";
    
    $stmt_count = $conn->query(
        "SELECT COUNT(*) as total FROM daily_actions_log"
    );
    $total = $stmt_count->fetch(PDO::FETCH_ASSOC)['total'];
    echo "إجمالي السجلات المتبقية: $total\n";
    
    $stmt_size = $conn->query(
        "SELECT 
            ROUND(((data_length + index_length) / 1024 / 1024), 2) AS size_mb 
         FROM information_schema.TABLES 
         WHERE table_name = 'daily_actions_log'"
    );
    $size = $stmt_size->fetch(PDO::FETCH_ASSOC)['size_mb'];
    echo "حجم الجدول: {$size} MB\n";
    
    echo "\n=== انتهى التنظيف بنجاح ===\n";
    
} catch (Exception $e) {
    echo "✗ خطأ: " . $e->getMessage() . "\n";
    error_log("[Cleanup Error] " . $e->getMessage());
    exit(1);
}
?>
