<?php
/**
 * claim_daily_reward.php - بدون توستات مزعجة
 * يمنح المستخدم مكافأة تسجيل الدخول اليومي
 */
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';
require 'PointsSystem.php';

// استقبال البيانات
$data = json_decode(file_get_contents('php://input'), true);
$userId = $data['user_id'] ?? $_POST['user_id'] ?? 0;
$coupleId = $data['couple_id'] ?? $_POST['couple_id'] ?? 0;

if ($userId <= 0) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required']));
}

try {
    $pointsSystem = new PointsSystem($conn);
    $result = $pointsSystem->checkDailyLogin($userId, $coupleId);
    
    if ($result['success']) {
        echo json_encode([
            'status' => 'success',
            'message' => '', // ★★★ إزالة الرسالة ★★★
            'data' => [
                'xp_earned' => $result['xp_earned'],
                'love_points_earned' => $result['love_points_earned'],
                'level_up' => $result['level_up']
            ]
        ]);
    } else {
        http_response_code(400);
        echo json_encode([
            'status' => 'error',
            'message' => '' // ★★★ إزالة الرسالة ★★★
        ]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>