<?php
// change_password.php
// يقوم بتغيير كلمة مرور المستخدم بعد التحقق من صحة كلمة المرور الحالية.

ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

require_once 'db_connect.php';

try {
    // التأكد من أن الاتصال بقاعدة البيانات ناجح
    if (!isset($conn)) {
        throw new Exception("فشل الاتصال بقاعدة البيانات.");
    }

    // 1. استقبال البيانات من التطبيق
    $data = json_decode(file_get_contents('php://input'), true);
    $user_id = $data['user_id'] ?? null;
    $current_password = $data['current_password'] ?? null;
    $new_password = $data['new_password'] ?? null;

    // 2. التحقق من أن كل البيانات المطلوبة موجودة
    if (empty($user_id) || empty($current_password) || empty($new_password)) {
        throw new Exception("الرجاء ملء جميع الحقول.");
    }

    // 3. التحقق من قوة كلمة المرور الجديدة
    if (strlen($new_password) < 8) {
        throw new Exception("يجب أن تتكون كلمة المرور الجديدة من 8 أحرف على الأقل.");
    }

    // 4. جلب كلمة المرور المشفرة الحالية للمستخدم من قاعدة البيانات
    $stmt = $conn->prepare("SELECT password_hash FROM users WHERE id = :id");
    $stmt->execute([':id' => $user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        throw new Exception("المستخدم غير موجود.");
    }

    // 5. التحقق من تطابق كلمة المرور الحالية
    if (password_verify($current_password, $user['password_hash'])) {
        // كلمة المرور الحالية صحيحة، يمكننا الآن تحديثها

        // 6. تشفير كلمة المرور الجديدة
        $new_password_hash = password_hash($new_password, PASSWORD_DEFAULT);

        // 7. تحديث كلمة المرور في قاعدة البيانات
        $stmt_update = $conn->prepare("UPDATE users SET password_hash = :new_hash WHERE id = :id");
        $stmt_update->execute([
            ':new_hash' => $new_password_hash,
            ':id' => $user_id
        ]);

        // 8. إرسال رد ناجح
        echo json_encode([
            'status' => 'success',
            'message' => 'تم تغيير كلمة المرور بنجاح.'
        ]);

    } else {
        // كلمة المرور الحالية غير صحيحة
        throw new Exception("كلمة المرور الحالية التي أدخلتها غير صحيحة.");
    }

} catch (Throwable $e) {
    // إرسال رد خطأ مع تحديد الكود المناسب
    // 400 for Bad Request, 401 for Unauthorized, 500 for Server Error
    if (http_response_code( ) < 400) {
        http_response_code(400 );
    }
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}

exit();
?>
