<?php
// block_user.php

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);

$blockerId = $data['blocker_id'] ?? 0;
$blockedId = $data['blocked_id'] ?? 0;

if (empty($blockerId) || empty($blockedId)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'معرفات المستخدمين مطلوبة لتنفيذ الحظر.']));
}

if ($blockerId === $blockedId) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'لا يمكنك حظر نفسك.']));
}

try {
    $stmt = $conn->prepare(
        "INSERT INTO blocked_users (blocker_id, blocked_id) 
         VALUES (:blocker_id, :blocked_id)"
    );

    $stmt->execute([
        ':blocker_id' => $blockerId,
        ':blocked_id' => $blockedId
    ]);

    echo json_encode([
        'status' => 'success',
        'message' => 'تم حظر المستخدم بنجاح.'
    ]);

} catch (PDOException $e) {
    // خطأ 1062 يعني أن المستخدم حاول حظر نفس الشخص مرتين (إدخال مكرر)
    if ($e->errorInfo[1] == 1062) {
        http_response_code(409 ); // 409 Conflict
        echo json_encode(['status' => 'error', 'message' => 'هذا المستخدم محظور بالفعل.']);
    } else {
        http_response_code(500 );
        error_log("Block User Error: " . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم أثناء محاولة الحظر.']);
    }
} catch (Exception $e) {
    http_response_code(500 );
    error_log("Block User Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ عام في الخادم.']);
}
?>
