<?php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$pusher_available = false;
if (file_exists(__DIR__ . '/PusherHelper.php')) {
    try {
        require_once __DIR__ . '/PusherHelper.php';
        $pusher_available = function_exists('send_pusher_trigger');
    } catch (Exception $e) {
        error_log("PusherHelper error: " . $e->getMessage());
    }
}

$data = json_decode(file_get_contents('php://input'), true);
$adminId = isset($data['admin_id']) ? (int)$data['admin_id'] : 0;
$targetId = isset($data['target_id']) ? (int)$data['target_id'] : 0;
$roomId = isset($data['room_id']) ? (int)$data['room_id'] : 0;
$reason = isset($data['reason']) ? trim($data['reason']) : '';

if ($adminId <= 0 || $targetId <= 0 || $roomId <= 0) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'بيانات غير مكتملة']));
}

try {
    $conn->beginTransaction();
    
    $stmt_admin = $conn->prepare("SELECT role FROM room_members WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_admin->execute([':room_id' => $roomId, ':user_id' => $adminId]);
    $admin = $stmt_admin->fetch();
    
    if (!$admin || !in_array($admin['role'], ['admin', 'owner'])) {
        throw new Exception("غير مصرح");
    }
    
    $stmt_target = $conn->prepare("SELECT role FROM room_members WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_target->execute([':room_id' => $roomId, ':user_id' => $targetId]);
    $target = $stmt_target->fetch();
    
    if ($target && $target['role'] === 'owner') {
        throw new Exception("لا يمكن حظر المالك");
    }
    
    if ($admin['role'] === 'admin' && $target && $target['role'] === 'admin') {
        throw new Exception("لا يمكن حظر مشرف آخر");
    }
    
    $stmt_user = $conn->prepare("SELECT display_name, level, profile_image_url, frame_identifier, name_color, font_identifier, is_verified FROM users WHERE id = :user_id");
    $stmt_user->execute([':user_id' => $targetId]);
    $user = $stmt_user->fetch(PDO::FETCH_ASSOC);
    $userName = $user ? $user['display_name'] : 'مستخدم';
    
    $stmt_ban = $conn->prepare("INSERT INTO room_banned_users (room_id, user_id, banned_by, reason) VALUES (:room_id, :user_id, :banned_by, :reason) ON DUPLICATE KEY UPDATE banned_at = NOW(), reason = :reason");
    $stmt_ban->execute([
        ':room_id' => $roomId,
        ':user_id' => $targetId,
        ':banned_by' => $adminId,
        ':reason' => $reason
    ]);
    
    // ✅✅ تحديث حالة الاتصال بدلاً من الحذف
    $stmt_update = $conn->prepare("UPDATE room_members SET is_online = 0 WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_update->execute([':room_id' => $roomId, ':user_id' => $targetId]);
    
    $systemMessage = "$userName تم حظره من الغرفة";
    $stmt_msg = $conn->prepare("INSERT INTO room_messages (room_id, user_id, message_text, is_system) VALUES (?, ?, ?, 1)");
    $stmt_msg->execute([$roomId, $targetId, $systemMessage]);
    $messageId = $conn->lastInsertId();
    
    if ($pusher_available) {
        try {
            send_pusher_trigger(
                "c0a2fe3c47f0775d0be1",
                "85330156aec9dd641145",
                "2109257",
                "mt1",
                'user-' . $targetId,
                'banned-from-room',
                ['room_id' => $roomId]
            );
            
            if ($user) {
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1",
                    "85330156aec9dd641145",
                    "2109257",
                    "mt1",
                    'presence-room-' . $roomId,
                    'new-message',
                    [
                        'id' => (int)$messageId,
                        'room_id' => $roomId,
                        'user_id' => $targetId,
                        'user_name' => $userName,
                        'user_level' => (int)$user['level'],
                        'user_image_url' => $user['profile_image_url'],
                        'frame_identifier' => $user['frame_identifier'],
                        'name_color' => $user['name_color'],
                        'font_identifier' => $user['font_identifier'],
                        'is_verified' => (int)$user['is_verified'],
                        'message_text' => $systemMessage,
                        'is_system' => true,
                        'created_at' => date('Y-m-d H:i:s')
                    ]
                );
            }
        } catch (Exception $e) {
            error_log("Pusher failed: " . $e->getMessage());
        }
    }
    
    $conn->commit();
    echo json_encode(['status' => 'success', 'message' => 'تم الحظر']);
} catch (Exception $e) {
    if ($conn->inTransaction()) $conn->rollBack();
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>