<?php
// badge_helper.php

/**
 * تُرجع هذه الدالة رابط URL الخاص بشارة المستوى المناسبة.
 * يتم فحص المستويات من الأعلى إلى الأدنى لضمان الحصول على الشارة الصحيحة.
 *
 * @param int $level مستوى المستخدم.
 * @return string|null رابط الشارة، أو null إذا لم تكن هناك شارة.
 */
function get_badge_url_for_level(int $level): ?string
{
    // ★★★★★   تنبيه: تأكد من أن هذا الرابط صحيح ويشير إلى مجلد الشارات في استضافتك   ★★★★★
    $base_url = "https://latrotech.online/Copel/badges/"; 

    $badge_file = null;

    if ($level >= 50 ) {
        $badge_file = 'badge_level_50.png';
    } elseif ($level >= 45) {
        $badge_file = 'badge_level_45.png';
    } elseif ($level >= 40) {
        $badge_file = 'badge_level_40.png';
    } elseif ($level >= 35) {
        $badge_file = 'badge_level_35.png';
    } elseif ($level >= 30) {
        $badge_file = 'badge_level_30.png';
    } elseif ($level >= 25) {
        $badge_file = 'badge_level_25.png';
    } elseif ($level >= 20) {
        $badge_file = 'badge_level_20.png';
    } elseif ($level >= 15) {
        $badge_file = 'badge_level_15.png';
    } elseif ($level >= 10) {
        $badge_file = 'badge_level_10.png';
    } elseif ($level >= 5) {
        $badge_file = 'badge_level_5.png';
    }

    if ($badge_file) {
        return $base_url . $badge_file;
    }

    return null; // لا توجد شارة لهذا المستوى
}
?>
