<?php
// ask_truth_question.php - v3 (The Final Fix Applied)

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/PusherHelper.php'; 
require 'db_connect.php'; 

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'php-errors.log');
error_reporting(E_ALL);

$data = json_decode(file_get_contents('php://input'), true);

// --- استقبال البيانات والتحقق منها ---
$gameId = $data['game_id'] ?? 0;
$userId = $data['user_id'] ?? 0; // هذا هو السائل
$questionText = trim($data['question_text'] ?? '');

if (empty($gameId) || empty($userId) || empty($questionText)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'Game ID, User ID, and question text are required.']));
}

$conn->beginTransaction();

try {
    // 1. جلب معلومات اللعبة والتأكد من أن الدور على المستخدم الحالي
    $stmt_game = $conn->prepare("SELECT * FROM truth_games WHERE id = :game_id AND status = 'active'");
    $stmt_game->execute(['game_id' => $gameId]);
    $game = $stmt_game->fetch(PDO::FETCH_ASSOC);

    if (!$game) {
        throw new Exception("Game not found or has ended.");
    }

    if ((int)$game['current_turn_user_id'] !== (int)$userId) {
        throw new Exception("It's not your turn to ask a question.");
    }

    // 2. التأكد من عدم وجود سؤال آخر ينتظر إجابة
    $stmt_check = $conn->prepare("SELECT id FROM truth_game_rounds WHERE game_id = :game_id AND answer_text IS NULL");
    $stmt_check->execute(['game_id' => $gameId]);
    if ($stmt_check->fetch()) {
        throw new Exception("You cannot ask a new question until the current one is answered.");
    }

    // 3. جلب بيانات الشريك (المستقبل) لتحديث الدور وإرسال الإشعار
    $stmt_partner = $conn->prepare(
        "SELECT CASE 
            WHEN c.user1_id = :current_user THEN c.user2_id 
            ELSE c.user1_id 
         END as partner_id
         FROM couples c
         WHERE c.id = :couple_id"
    );
    $stmt_partner->execute(['current_user' => $userId, 'couple_id' => $game['couple_id']]);
    $partner = $stmt_partner->fetch(PDO::FETCH_ASSOC);
    $partnerId = $partner['partner_id'];

    if (empty($partnerId)) {
        throw new Exception("Could not determine the recipient partner.");
    }

    // ★★★★★   بداية التعديل الجذري   ★★★★★
    // 4. تحديث الدور في جدول اللعبة لينتقل إلى الشريك (المجيب)
    $stmt_turn = $conn->prepare("UPDATE truth_games SET current_turn_user_id = :recipient_id WHERE id = :game_id");
    $stmt_turn->execute([':recipient_id' => $partnerId, ':game_id' => $gameId]);
    // ★★★★★    نهاية التعديل الجذري    ★★★★★

    // 5. إضافة السؤال الجديد إلى قاعدة البيانات مع تاريخ انتهاء الصلاحية
    $expires_at = date('Y-m-d H:i:s', strtotime('+2 hours'));
    
    $stmt_insert = $conn->prepare(
        "INSERT INTO truth_game_rounds (game_id, question_user_id, question_text, expires_at) 
         VALUES (:game_id, :user_id, :question_text, :expires_at)"
    );
    $stmt_insert->execute([
        'game_id' => $gameId,
        'user_id' => $userId,
        'question_text' => $questionText,
        'expires_at' => $expires_at
    ]);
    $roundId = $conn->lastInsertId();

    // 6. إرسال حدث Pusher إلى الطرف الآخر
    $pusher_data = [
        'round_id' => (int)$roundId,
        'question_user_id' => (int)$userId,
        'question_text' => $questionText,
        'expires_at' => $expires_at,
        'next_turn_user_id' => (int)$partnerId // إرسال الدور الجديد
    ];
    
    // القناة خاصة بالمستخدم المستقبل
    $channel_name = 'user-' . $partnerId;
    
    send_pusher_trigger(
        "c0a2fe3c47f0775d0be1", 
        "85330156aec9dd641145", 
        "2109257", 
        "mt1", 
        $channel_name, 
        'new-truth-question', // اسم الحدث
        $pusher_data
    );

    $conn->commit();

    // 7. إرسال رد ناجح إلى التطبيق
    echo json_encode([
        'status' => 'success',
        'message' => 'Question sent successfully.',
        'data' => $pusher_data
    ]);

} catch (Exception $e) {
    $conn->rollBack();
    http_response_code(400 );
    error_log("Ask Truth Question Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

$conn = null;
?>
