<?php
/**
 * apply_customization.php - DEPRECATED - استخدم apply_shop_item.php بدلاً منه
 * =========================================
 * هذا الملف محفوظ للتوافق مع الإصدارات القديمة فقط
 * يُنصح باستخدام apply_shop_item.php للتطبيق/الإلغاء
 * 
 * @version 2.3 - Fixed for new system
 * @date 2026-02-14
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', 0);

// التحقق من وجود ملف الاتصال
if (!file_exists('db_connect.php')) {
    http_response_code(500);
    exit(json_encode([
        'status' => 'error', 
        'message' => 'خطأ في الاتصال بقاعدة البيانات'
    ]));
}

require_once 'db_connect.php';

// استقبال البيانات
$input = json_decode(file_get_contents('php://input'), true);
$userId = $input['user_id'] ?? $_POST['user_id'] ?? 0;
$customizationType = $input['customization_type'] ?? $_POST['customization_type'] ?? '';
$itemIdentifier = $input['item_identifier'] ?? $_POST['item_identifier'] ?? '';

// ========================================
// 1. التحقق من صحة البيانات
// ========================================
if ($userId <= 0 || empty($customizationType) || empty($itemIdentifier)) {
    http_response_code(400);
    exit(json_encode([
        'status' => 'error', 
        'message' => 'بيانات غير كاملة. يجب توفير user_id و customization_type و item_identifier.'
    ]));
}

// ========================================
// 2. التحقق من نوع التخصيص الصالح
// ========================================
$validTypes = ['frame', 'font', 'color', 'badge'];
if (!in_array($customizationType, $validTypes)) {
    http_response_code(400);
    exit(json_encode([
        'status' => 'error', 
        'message' => 'نوع تخصيص غير صالح. الأنواع المتاحة: ' . implode(', ', $validTypes)
    ]));
}

try {
    // ========================================
    // 3. البحث عن العنصر (بدون التحقق من الفتح)
    // ========================================
    $stmt = $conn->prepare("
        SELECT * 
        FROM shop_items 
        WHERE item_type = :type 
        AND item_identifier = :identifier
        AND is_active = TRUE
        LIMIT 1
    ");
    
    $stmt->execute([
        ':type' => $customizationType,
        ':identifier' => $itemIdentifier
    ]);
    
    $item = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$item) {
        throw new Exception('العنصر غير موجود');
    }
    
    $itemId = (int)$item['id'];
    
    // ========================================
    // 4. التحقق من أن المستخدم يملك هذا العنصر
    // ========================================
    $stmt = $conn->prepare("
        SELECT id 
        FROM user_unlocked_items 
        WHERE user_id = :uid 
        AND item_id = :item_id
    ");
    
    $stmt->execute([
        ':uid' => $userId,
        ':item_id' => $itemId
    ]);
    
    if (!$stmt->fetch()) {
        throw new Exception('يجب عليك فتح هذا العنصر أولاً من المتجر');
    }
    
    // ========================================
    // 5. بدء Transaction
    // ========================================
    $conn->beginTransaction();
    
    // ========================================
    // 6. حذف التطبيق السابق من نفس النوع
    // ========================================
    $stmt = $conn->prepare("
        DELETE FROM user_applied_items 
        WHERE user_id = :uid 
        AND item_type = :type
    ");
    
    $stmt->execute([
        ':uid' => $userId,
        ':type' => $customizationType
    ]);
    
    // ========================================
    // 7. إضافة التطبيق الجديد
    // ========================================
    $stmt = $conn->prepare("
        INSERT INTO user_applied_items (user_id, item_type, item_id) 
        VALUES (:uid, :type, :item_id)
    ");
    
    $stmt->execute([
        ':uid' => $userId,
        ':type' => $customizationType,
        ':item_id' => $itemId
    ]);
    
    // ========================================
    // 8. تحديث جدول users
    // ========================================
    $columnMap = [
        'frame' => 'frame_identifier',
        'font' => 'font_identifier',
        'color' => 'name_color',
        'badge' => 'badge_identifier'
    ];
    
    if (!isset($columnMap[$customizationType])) {
        throw new Exception('نوع تخصيص غير مدعوم');
    }
    
    $column = $columnMap[$customizationType];
    
    $stmt = $conn->prepare(
        "UPDATE users 
         SET $column = :value 
         WHERE id = :uid"
    );
    
    $stmt->execute([
        ':value' => $itemIdentifier, 
        ':uid' => $userId
    ]);
    
    if ($stmt->rowCount() === 0) {
        $stmt_check_user = $conn->prepare("SELECT id FROM users WHERE id = :uid");
        $stmt_check_user->execute([':uid' => $userId]);
        
        if (!$stmt_check_user->fetch()) {
            throw new Exception('المستخدم غير موجود');
        }
    }
    
    // ========================================
    // 9. Commit Transaction
    // ========================================
    $conn->commit();
    
    // ========================================
    // 10. مسح الكاش
    // ========================================
    if (function_exists('apcu_delete')) {
        apcu_delete("shop_items_user_{$userId}_v2");
        apcu_delete("shop_items_user_{$userId}_v3");
        apcu_delete("dashboard_data_{$userId}");
        apcu_delete("my_items_user_{$userId}");
    }
    
    // ========================================
    // 11. بناء معلومات إضافية للتدرجات اللونية
    // ========================================
    $additionalInfo = [];
    
    if ($customizationType === 'color' && strpos($itemIdentifier, 'gradient:') === 0) {
        $parts = explode(':', $itemIdentifier);
        if (count($parts) >= 3) {
            $gradientType = $parts[1];
            $colors = explode(',', $parts[2]);
            
            $additionalInfo = [
                'gradient_type' => $gradientType,
                'colors_count' => count($colors),
                'colors' => array_map(function($c) {
                    $c = trim($c);
                    return (strpos($c, '#') === 0) ? $c : '#' . strtoupper($c);
                }, $colors)
            ];
        }
    }
    
    // ========================================
    // 12. بناء الاستجابة
    // ========================================
    $typeNamesAr = [
        'frame' => 'الإطار',
        'font' => 'الخط',
        'color' => 'اللون',
        'badge' => 'الشارة'
    ];
    
    $typeName = $typeNamesAr[$customizationType] ?? 'التخصيص';
    
    $response = [
        'status' => 'success',
        'message' => "تم تطبيق $typeName بنجاح! ✨",
        'data' => [
            'customization_type' => $customizationType,
            'applied_value' => $itemIdentifier,
            'item' => [
                'id' => $itemId,
                'name_ar' => $item['item_name_ar'],
                'preview_url' => $item['item_preview_url'],
                'rarity' => $item['rarity']
            ]
        ]
    ];
    
    if (!empty($additionalInfo)) {
        $response['data']['gradient_info'] = $additionalInfo;
    }
    
    echo json_encode($response);

} catch (PDOException $e) {
    // Rollback في حالة الخطأ
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    
    error_log("Apply Customization Error (DB): " . $e->getMessage() . 
              " | User: $userId | Type: $customizationType");
    
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'خطأ في قاعدة البيانات',
        'error_code' => 'DB_ERROR'
    ]);
    
} catch (Exception $e) {
    // Rollback في حالة الخطأ
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    
    error_log("Apply Customization Error: " . $e->getMessage() . 
              " | User: $userId | Type: $customizationType");
    
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage(),
        'error_code' => 'APPLY_FAILED'
    ]);
}
?>