<?php
// answer_truth_question.php - v7 (Fixed Turn Logic)
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/PusherHelper.php'; 
require 'db_connect.php'; 

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'php-errors.log');
error_reporting(E_ALL);

$data = json_decode(file_get_contents('php://input'), true);
$roundId = $data['round_id'] ?? 0;
$userId = $data['user_id'] ?? 0;
$answerText = trim($data['answer_text'] ?? '');

if (empty($roundId) || empty($userId) || empty($answerText)) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'Round ID, User ID, and answer text are required.']));
}

$conn->beginTransaction();

try {
    $stmt_round = $conn->prepare("SELECT * FROM truth_game_rounds WHERE id = :round_id AND answer_text IS NULL");
    $stmt_round->execute(['round_id' => $roundId]);
    $round = $stmt_round->fetch(PDO::FETCH_ASSOC);
    
    if (!$round) { 
        throw new Exception("Question not found or has already been answered."); 
    }
    
    if ((int)$round['question_user_id'] === (int)$userId) { 
        throw new Exception("You cannot answer your own question."); 
    }
    
    $expires_at = new DateTime($round['expires_at']);
    $now = new DateTime();
    if ($now > $expires_at) { 
        throw new Exception("Time's up! You can no longer answer this question."); 
    }
    
    // تحديث الجولة بالإجابة
    $stmt_update = $conn->prepare("UPDATE truth_game_rounds SET answer_user_id = :user_id, answer_text = :answer_text, answered_at = NOW() WHERE id = :round_id");
    $stmt_update->execute(['user_id' => $userId, 'answer_text' => $answerText, 'round_id' => $roundId]);
    
    // ★★★★★ التعديل الأساسي: الدور ينتقل للمجيب (الذي أجاب للتو) ليطرح السؤال التالي ★★★★★
    $next_turn_user_id = (int)$userId; // المجيب هو من سيسأل التالي
    $gameId = (int)$round['game_id'];
    
    $stmt_turn = $conn->prepare("UPDATE truth_games SET current_turn_user_id = :turn_id WHERE id = :game_id");
    $stmt_turn->execute(['turn_id' => $next_turn_user_id, 'game_id' => $gameId]);
    
    // إرسال إشعار للسائل الأصلي
    $original_asker_id = (int)$round['question_user_id'];
    
    $pusher_data = [
        'round_id' => (int)$roundId,
        'answer_user_id' => (int)$userId,
        'answer_text' => $answerText,
        'next_turn_user_id' => $next_turn_user_id
    ];
    
    $channel_name = 'user-' . $original_asker_id;
    send_pusher_trigger(
        "c0a2fe3c47f0775d0be1", 
        "85330156aec9dd641145", 
        "2109257", 
        "mt1", 
        $channel_name, 
        'new-truth-answer', 
        $pusher_data
    );
    
    $conn->commit();
    
    echo json_encode([
        'status' => 'success',
        'message' => 'تم إرسال الإجابة بنجاح.'
    ]);

} catch (Exception $e) {
    $conn->rollBack();
    http_response_code(400);
    error_log("Answer Truth Question Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

$conn = null;
?>