<?php
// dashboard_analytics.php
// ================================================
// لوحة الأناليتكس + إدارة حظر الأجهزة
// ================================================

// حماية بسيطة - غيّر كلمة المرور
$admin_password = "admin2026";
$auth = isset($_GET['key']) ? $_GET['key'] : '';
if ($auth !== $admin_password) {
    http_response_code(403);
    die("<h2 style='font-family:Arial;text-align:center;margin-top:100px'>⛔ غير مصرح بالوصول</h2><p style='text-align:center'>أضف ?key=admin2026 للرابط</p>");
}

$conn = new mysqli("localhost", "u323701002_us_coc", "AS_05344465928pr", "u323701002_coc");
$conn->set_charset("utf8mb4");

// -----------------------------------------------
// معالجة طلبات الحظر AJAX
// -----------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json; charset=utf-8');
    $input  = json_decode(file_get_contents('php://input'), true);
    $action = $input['action'] ?? '';

    // إنشاء جدول الحظر إذا لم يكن موجوداً
    $conn->query("
        CREATE TABLE IF NOT EXISTS banned_devices (
            id           INT AUTO_INCREMENT PRIMARY KEY,
            device_id    VARCHAR(255) NOT NULL,
            user_id      INT DEFAULT NULL,
            reason       TEXT DEFAULT NULL,
            banned_by    VARCHAR(100) DEFAULT 'admin',
            ban_date     DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            ban_expires  DATETIME DEFAULT NULL,
            is_permanent TINYINT(1) DEFAULT 1,
            is_active    TINYINT(1) DEFAULT 1,
            UNIQUE KEY uq_device (device_id),
            INDEX idx_active (is_active)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");

    if ($action === 'ban') {
        $device_id    = trim($input['device_id'] ?? '');
        $user_id      = intval($input['user_id'] ?? 0) ?: null;
        $reason       = trim($input['reason'] ?? 'مخالفة قواعد الاستخدام');
        $is_permanent = intval($input['is_permanent'] ?? 1);
        $ban_expires  = ($is_permanent == 0 && !empty($input['ban_expires'])) ? $input['ban_expires'] : null;

        if (!$device_id) { echo json_encode(['success' => false, 'message' => 'device_id مطلوب']); exit; }

        $stmt = $conn->prepare("
            INSERT INTO banned_devices (device_id, user_id, reason, banned_by, ban_expires, is_permanent, is_active)
            VALUES (?, ?, ?, 'admin', ?, ?, 1)
            ON DUPLICATE KEY UPDATE
                user_id = VALUES(user_id), reason = VALUES(reason),
                ban_date = NOW(), ban_expires = VALUES(ban_expires),
                is_permanent = VALUES(is_permanent), is_active = 1
        ");
        $stmt->bind_param("sissi", $device_id, $user_id, $reason, $ban_expires, $is_permanent);
        $stmt->execute();
        echo json_encode(['success' => true, 'message' => 'تم حظر الجهاز بنجاح']);

    } elseif ($action === 'unban') {
        $device_id = trim($input['device_id'] ?? '');
        $stmt = $conn->prepare("UPDATE banned_devices SET is_active = 0 WHERE device_id = ?");
        $stmt->bind_param("s", $device_id);
        $stmt->execute();
        echo json_encode(['success' => true, 'message' => 'تم رفع الحظر']);

    } else {
        echo json_encode(['success' => false, 'message' => 'action غير صالح']);
    }
    $conn->close();
    exit;
}

// -----------------------------------------------
// جلب البيانات للعرض
// -----------------------------------------------

// إجمالي المستخدمين
$total_users = $conn->query("SELECT COUNT(*) as c FROM users")->fetch_assoc()['c'];

// نشطون الآن (آخر 10 دقائق)
$active_now = $conn->query("SELECT COUNT(*) as c FROM users WHERE is_active=1 AND last_active >= NOW() - INTERVAL 10 MINUTE")->fetch_assoc()['c'];

// نشطون اليوم
$active_today = $conn->query("SELECT COUNT(DISTINCT user_id) as c FROM user_activity_sessions WHERE DATE(session_start)=CURDATE()")->fetch_assoc()['c'];

// إجمالي الجلسات
$total_sessions = $conn->query("SELECT COUNT(*) as c FROM user_activity_sessions")->fetch_assoc()['c'];

// متوسط مدة الجلسة
$avg_sec = $conn->query("SELECT AVG(duration_seconds) as a FROM user_activity_sessions WHERE duration_seconds > 0")->fetch_assoc()['a'];
$avg_min = $avg_sec ? round($avg_sec / 60, 1) : 0;

// إجمالي الأجهزة
$total_devices = $conn->query("SELECT COUNT(*) as c FROM user_devices")->fetch_assoc()['c'];

// تثبيتات هذا الشهر
$new_installs = $conn->query("SELECT COUNT(*) as c FROM user_devices WHERE first_install_date >= DATE_FORMAT(NOW(),'%Y-%m-01')")->fetch_assoc()['c'];

// الأجهزة المحظورة
$conn->query("CREATE TABLE IF NOT EXISTS banned_devices (id INT AUTO_INCREMENT PRIMARY KEY, device_id VARCHAR(255) NOT NULL UNIQUE, user_id INT DEFAULT NULL, reason TEXT, banned_by VARCHAR(100) DEFAULT 'admin', ban_date DATETIME DEFAULT CURRENT_TIMESTAMP, ban_expires DATETIME DEFAULT NULL, is_permanent TINYINT(1) DEFAULT 1, is_active TINYINT(1) DEFAULT 1) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
$banned_count = $conn->query("SELECT COUNT(*) as c FROM banned_devices WHERE is_active=1")->fetch_assoc()['c'];

// نشاط آخر 7 أيام
$daily_rows = $conn->query("
    SELECT DATE(session_start) as day, COUNT(DISTINCT user_id) as cnt
    FROM user_activity_sessions
    WHERE session_start >= NOW() - INTERVAL 7 DAY
    GROUP BY DATE(session_start) ORDER BY day ASC
");
$days_labels = $days_data = [];
while ($r = $daily_rows->fetch_assoc()) {
    $days_labels[] = $r['day'];
    $days_data[]   = $r['cnt'];
}

// قائمة الأجهزة المحظورة
$banned_list = [];
$check = $conn->query("SHOW TABLES LIKE 'banned_devices'");
if ($check->num_rows > 0) {
    $bl = $conn->query("
        SELECT bd.*, u.display_name, u.username
        FROM banned_devices bd
        LEFT JOIN users u ON bd.user_id = u.id
        WHERE bd.is_active = 1
        ORDER BY bd.ban_date DESC
        LIMIT 50
    ");
    while ($r = $bl->fetch_assoc()) $banned_list[] = $r;
}

// آخر الجلسات
$sessions_list = $conn->query("
    SELECT s.*, u.display_name, u.username, d.device_model, d.android_version, d.device_id as dev_id
    FROM user_activity_sessions s
    LEFT JOIN users u ON s.user_id = u.id
    LEFT JOIN user_devices d ON s.device_id = d.device_id
    ORDER BY s.session_start DESC
    LIMIT 30
");
$sessions = [];
while ($r = $sessions_list->fetch_assoc()) $sessions[] = $r;

// قائمة المستخدمين مع أجهزتهم
$users_list = $conn->query("
    SELECT u.id, u.display_name, u.username, u.is_active, u.last_active, u.app_open_count,
           d.device_id, d.device_model, d.android_version, d.app_version, d.total_opens,
           IF(bd.id IS NOT NULL AND bd.is_active=1, 1, 0) as is_banned,
           bd.reason as ban_reason
    FROM users u
    LEFT JOIN user_devices d ON u.id = d.user_id
    LEFT JOIN banned_devices bd ON d.device_id = bd.device_id AND bd.is_active = 1
    ORDER BY u.id DESC
    LIMIT 100
");
$users = [];
while ($r = $users_list->fetch_assoc()) $users[] = $r;

$conn->close();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>لوحة الأناليتكس - Copel</title>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/4.4.0/chart.umd.min.js"></script>
<style>
* { box-sizing: border-box; margin: 0; padding: 0; }
body { font-family: 'Segoe UI', Tahoma, Arial, sans-serif; background: #0f0f1a; color: #e0e0e0; direction: rtl; }
.header { background: linear-gradient(135deg, #1a1a2e, #16213e); padding: 20px 30px; border-bottom: 1px solid #2a2a4a; display: flex; align-items: center; justify-content: space-between; }
.header h1 { font-size: 22px; color: #fff; }
.header h1 span { color: #e94560; }
.live-badge { background: #e94560; color: #fff; padding: 4px 12px; border-radius: 20px; font-size: 12px; animation: pulse 2s infinite; }
@keyframes pulse { 0%,100%{opacity:1} 50%{opacity:0.6} }
.nav { background: #16213e; display: flex; gap: 5px; padding: 10px 30px; border-bottom: 1px solid #2a2a4a; flex-wrap: wrap; }
.nav button { background: transparent; border: none; color: #aaa; padding: 8px 18px; border-radius: 8px; cursor: pointer; font-size: 14px; transition: all 0.2s; }
.nav button:hover, .nav button.active { background: #e94560; color: #fff; }
.container { padding: 25px 30px; max-width: 1400px; margin: 0 auto; }
.page { display: none; }
.page.active { display: block; }

/* Cards */
.cards { display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 15px; margin-bottom: 25px; }
.card { background: #16213e; border-radius: 12px; padding: 20px; border: 1px solid #2a2a4a; transition: transform 0.2s; }
.card:hover { transform: translateY(-3px); }
.card .label { font-size: 12px; color: #888; margin-bottom: 8px; }
.card .value { font-size: 28px; font-weight: bold; color: #fff; }
.card .sub { font-size: 12px; color: #666; margin-top: 5px; }
.card.green .value { color: #4ade80; }
.card.red .value { color: #f87171; }
.card.blue .value { color: #60a5fa; }
.card.yellow .value { color: #fbbf24; }
.card.purple .value { color: #a78bfa; }

/* Chart */
.chart-box { background: #16213e; border-radius: 12px; padding: 20px; border: 1px solid #2a2a4a; margin-bottom: 25px; }
.chart-box h3 { color: #fff; margin-bottom: 15px; font-size: 15px; }
.chart-box canvas { max-height: 250px; }

/* Table */
.table-box { background: #16213e; border-radius: 12px; border: 1px solid #2a2a4a; margin-bottom: 25px; overflow: hidden; }
.table-box .table-header { padding: 15px 20px; border-bottom: 1px solid #2a2a4a; display: flex; align-items: center; justify-content: space-between; }
.table-box .table-header h3 { color: #fff; font-size: 15px; }
table { width: 100%; border-collapse: collapse; }
th { background: #0f1929; padding: 10px 15px; text-align: right; font-size: 12px; color: #888; font-weight: 500; }
td { padding: 10px 15px; border-bottom: 1px solid #1a2a3a; font-size: 13px; vertical-align: middle; }
tr:last-child td { border-bottom: none; }
tr:hover td { background: rgba(255,255,255,0.03); }
.badge { display: inline-block; padding: 2px 10px; border-radius: 20px; font-size: 11px; font-weight: 500; }
.badge.online { background: rgba(74,222,128,0.15); color: #4ade80; }
.badge.offline { background: rgba(100,100,100,0.15); color: #666; }
.badge.banned { background: rgba(248,113,113,0.15); color: #f87171; }

/* Ban Form */
.ban-form { background: #16213e; border-radius: 12px; padding: 20px; border: 1px solid #2a2a4a; margin-bottom: 25px; }
.ban-form h3 { color: #fff; margin-bottom: 15px; font-size: 15px; }
.form-row { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 12px; margin-bottom: 12px; }
.form-group label { display: block; font-size: 12px; color: #888; margin-bottom: 5px; }
.form-group input, .form-group select, .form-group textarea {
    width: 100%; background: #0f1929; border: 1px solid #2a2a4a; border-radius: 8px;
    padding: 9px 12px; color: #e0e0e0; font-size: 13px; outline: none;
    transition: border-color 0.2s;
}
.form-group input:focus, .form-group select:focus { border-color: #e94560; }
.btn { padding: 9px 20px; border-radius: 8px; border: none; cursor: pointer; font-size: 13px; font-weight: 500; transition: all 0.2s; }
.btn-red { background: #e94560; color: #fff; }
.btn-red:hover { background: #c73652; }
.btn-green { background: #16a34a; color: #fff; }
.btn-green:hover { background: #15803d; }
.btn-gray { background: #374151; color: #fff; }
.btn-gray:hover { background: #4b5563; }
.btn-sm { padding: 5px 12px; font-size: 12px; }

/* Alert */
.alert { padding: 12px 16px; border-radius: 8px; margin-bottom: 15px; font-size: 13px; display: none; }
.alert.success { background: rgba(74,222,128,0.1); border: 1px solid rgba(74,222,128,0.3); color: #4ade80; }
.alert.error { background: rgba(248,113,113,0.1); border: 1px solid rgba(248,113,113,0.3); color: #f87171; }

/* Search */
.search-box { position: relative; margin-bottom: 15px; }
.search-box input { width: 100%; background: #0f1929; border: 1px solid #2a2a4a; border-radius: 8px; padding: 9px 12px 9px 35px; color: #e0e0e0; font-size: 13px; outline: none; }
.search-box::before { content: '🔍'; position: absolute; left: 10px; top: 50%; transform: translateY(-50%); font-size: 14px; }

/* Device ID */
.device-id { font-family: monospace; font-size: 11px; color: #60a5fa; background: rgba(96,165,250,0.1); padding: 2px 6px; border-radius: 4px; cursor: pointer; }
.device-id:hover { background: rgba(96,165,250,0.2); }

@media(max-width:768px) {
    .container { padding: 15px; }
    .nav { padding: 8px 15px; }
    .header { padding: 15px; }
    .cards { grid-template-columns: repeat(2, 1fr); }
}
</style>
</head>
<body>

<div class="header">
    <h1>📊 لوحة تحكم <span>Copel</span></h1>
    <span class="live-badge">● مباشر</span>
</div>

<div class="nav">
    <button class="active" onclick="showPage('overview')">📈 نظرة عامة</button>
    <button onclick="showPage('users')">👥 المستخدمون</button>
    <button onclick="showPage('sessions')">🕐 الجلسات</button>
    <button onclick="showPage('ban')">⛔ إدارة الحظر</button>
    <button onclick="showPage('banned_list')">📋 قائمة المحظورين</button>
</div>

<div class="container">
    <div id="alert-box" class="alert"></div>

    <!-- ============ OVERVIEW ============ -->
    <div id="page-overview" class="page active">
        <div class="cards">
            <div class="card">
                <div class="label">👥 إجمالي المستخدمين</div>
                <div class="value"><?= number_format($total_users) ?></div>
            </div>
            <div class="card green">
                <div class="label">🟢 نشطون الآن</div>
                <div class="value"><?= $active_now ?></div>
                <div class="sub">آخر 10 دقائق</div>
            </div>
            <div class="card blue">
                <div class="label">📅 نشطون اليوم</div>
                <div class="value"><?= $active_today ?></div>
            </div>
            <div class="card yellow">
                <div class="label">📱 إجمالي الأجهزة</div>
                <div class="value"><?= $total_devices ?></div>
            </div>
            <div class="card purple">
                <div class="label">⬇️ تثبيتات الشهر</div>
                <div class="value"><?= $new_installs ?></div>
            </div>
            <div class="card">
                <div class="label">🔄 إجمالي الجلسات</div>
                <div class="value"><?= number_format($total_sessions) ?></div>
            </div>
            <div class="card">
                <div class="label">⏱️ متوسط الجلسة</div>
                <div class="value"><?= $avg_min ?>د</div>
            </div>
            <div class="card red">
                <div class="label">⛔ أجهزة محظورة</div>
                <div class="value"><?= $banned_count ?></div>
            </div>
        </div>

        <div class="chart-box">
            <h3>📈 المستخدمون النشطون - آخر 7 أيام</h3>
            <canvas id="dailyChart"></canvas>
        </div>
    </div>

    <!-- ============ USERS ============ -->
    <div id="page-users" class="page">
        <div class="search-box">
            <input type="text" id="user-search" placeholder="ابحث بالاسم أو اليوزر أو الجهاز..." oninput="filterUsers()">
        </div>
        <div class="table-box">
            <div class="table-header">
                <h3>👥 المستخدمون وأجهزتهم</h3>
                <span style="color:#888;font-size:12px"><?= count($users) ?> مستخدم</span>
            </div>
            <div style="overflow-x:auto">
            <table id="users-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>المستخدم</th>
                        <th>الجهاز</th>
                        <th>Device ID</th>
                        <th>أندرويد</th>
                        <th>فتحات</th>
                        <th>آخر نشاط</th>
                        <th>الحالة</th>
                        <th>إجراء</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($users as $u): ?>
                <tr>
                    <td style="color:#666"><?= $u['id'] ?></td>
                    <td>
                        <strong style="color:#fff"><?= htmlspecialchars($u['display_name'] ?? 'N/A') ?></strong><br>
                        <span style="color:#666;font-size:11px">@<?= htmlspecialchars($u['username'] ?? '') ?></span>
                    </td>
                    <td style="color:#aaa;font-size:12px"><?= htmlspecialchars($u['device_model'] ?? '-') ?></td>
                    <td>
                        <?php if ($u['device_id']): ?>
                        <span class="device-id" onclick="copyText('<?= $u['device_id'] ?>')" title="انقر للنسخ">
                            <?= substr($u['device_id'], 0, 12) ?>...
                        </span>
                        <?php else: ?>
                        <span style="color:#444">-</span>
                        <?php endif; ?>
                    </td>
                    <td style="color:#888;font-size:12px"><?= htmlspecialchars($u['android_version'] ?? '-') ?></td>
                    <td style="color:#60a5fa"><?= $u['total_opens'] ?? 0 ?></td>
                    <td style="color:#666;font-size:11px"><?= $u['last_active'] ? date('Y-m-d H:i', strtotime($u['last_active'])) : '-' ?></td>
                    <td>
                        <?php if ($u['is_banned']): ?>
                        <span class="badge banned">محظور</span>
                        <?php elseif ($u['is_active']): ?>
                        <span class="badge online">نشط</span>
                        <?php else: ?>
                        <span class="badge offline">غير نشط</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($u['device_id']): ?>
                            <?php if ($u['is_banned']): ?>
                            <button class="btn btn-green btn-sm" onclick="unbanDevice('<?= $u['device_id'] ?>')">رفع حظر</button>
                            <?php else: ?>
                            <button class="btn btn-red btn-sm" onclick="quickBan('<?= $u['device_id'] ?>', <?= $u['id'] ?>, '<?= addslashes($u['display_name']) ?>')">حظر</button>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            </div>
        </div>
    </div>

    <!-- ============ SESSIONS ============ -->
    <div id="page-sessions" class="page">
        <div class="table-box">
            <div class="table-header">
                <h3>🕐 آخر الجلسات</h3>
                <span style="color:#888;font-size:12px">آخر 30 جلسة</span>
            </div>
            <div style="overflow-x:auto">
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>المستخدم</th>
                        <th>الجهاز</th>
                        <th>بداية الجلسة</th>
                        <th>نهاية الجلسة</th>
                        <th>المدة</th>
                        <th>Device ID</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($sessions as $s): ?>
                <tr>
                    <td style="color:#666"><?= $s['id'] ?></td>
                    <td>
                        <strong style="color:#fff"><?= htmlspecialchars($s['display_name'] ?? 'N/A') ?></strong><br>
                        <span style="color:#666;font-size:11px">ID: <?= $s['user_id'] ?></span>
                    </td>
                    <td style="color:#aaa;font-size:12px"><?= htmlspecialchars($s['device_model'] ?? '-') ?></td>
                    <td style="font-size:12px;color:#aaa"><?= $s['session_start'] ?></td>
                    <td style="font-size:12px;color:#aaa">
                        <?= $s['session_end'] ? $s['session_end'] : '<span style="color:#4ade80">جارية ●</span>' ?>
                    </td>
                    <td style="color:#fbbf24">
                        <?php
                        $dur = $s['duration_seconds'];
                        if ($dur >= 60) echo floor($dur/60) . 'د ' . ($dur%60) . 'ث';
                        elseif ($dur > 0) echo $dur . 'ث';
                        else echo '<span style="color:#444">-</span>';
                        ?>
                    </td>
                    <td>
                        <span class="device-id" onclick="copyText('<?= $s['dev_id'] ?>')" title="انقر للنسخ">
                            <?= substr($s['dev_id'] ?? '-', 0, 12) ?>...
                        </span>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            </div>
        </div>
    </div>

    <!-- ============ BAN DEVICE ============ -->
    <div id="page-ban" class="page">
        <div class="ban-form">
            <h3>⛔ حظر جهاز جديد</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>Device ID *</label>
                    <input type="text" id="ban-device-id" placeholder="e.g. 6d1d7edf64634321">
                </div>
                <div class="form-group">
                    <label>User ID (اختياري)</label>
                    <input type="number" id="ban-user-id" placeholder="220">
                </div>
                <div class="form-group">
                    <label>نوع الحظر</label>
                    <select id="ban-permanent" onchange="toggleExpiry()">
                        <option value="1">دائم</option>
                        <option value="0">مؤقت</option>
                    </select>
                </div>
                <div class="form-group" id="expiry-group" style="display:none">
                    <label>تاريخ انتهاء الحظر</label>
                    <input type="datetime-local" id="ban-expires">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group" style="grid-column:1/-1">
                    <label>سبب الحظر</label>
                    <input type="text" id="ban-reason" value="مخالفة قواعد الاستخدام">
                </div>
            </div>
            <button class="btn btn-red" onclick="banDevice()">⛔ حظر الجهاز</button>
        </div>

        <div class="ban-form">
            <h3>✅ رفع الحظر</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>Device ID</label>
                    <input type="text" id="unban-device-id" placeholder="Device ID للجهاز المراد رفع حظره">
                </div>
            </div>
            <button class="btn btn-green" onclick="unbanFromInput()">✅ رفع الحظر</button>
        </div>
    </div>

    <!-- ============ BANNED LIST ============ -->
    <div id="page-banned_list" class="page">
        <div class="table-box">
            <div class="table-header">
                <h3>📋 الأجهزة المحظورة</h3>
                <span style="color:#f87171;font-size:13px;font-weight:bold"><?= count($banned_list) ?> محظور</span>
            </div>
            <?php if (empty($banned_list)): ?>
            <div style="text-align:center;padding:50px;color:#444">لا توجد أجهزة محظورة حالياً</div>
            <?php else: ?>
            <div style="overflow-x:auto">
            <table>
                <thead>
                    <tr>
                        <th>Device ID</th>
                        <th>المستخدم</th>
                        <th>السبب</th>
                        <th>تاريخ الحظر</th>
                        <th>النوع</th>
                        <th>ينتهي</th>
                        <th>إجراء</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($banned_list as $b): ?>
                <tr>
                    <td>
                        <span class="device-id" onclick="copyText('<?= $b['device_id'] ?>')" title="انقر للنسخ">
                            <?= htmlspecialchars($b['device_id']) ?>
                        </span>
                    </td>
                    <td>
                        <?php if ($b['display_name']): ?>
                        <strong style="color:#fff"><?= htmlspecialchars($b['display_name']) ?></strong><br>
                        <span style="color:#666;font-size:11px">ID: <?= $b['user_id'] ?></span>
                        <?php else: ?>
                        <span style="color:#444">-</span>
                        <?php endif; ?>
                    </td>
                    <td style="color:#fbbf24;font-size:12px"><?= htmlspecialchars($b['reason'] ?? '-') ?></td>
                    <td style="color:#888;font-size:12px"><?= date('Y-m-d H:i', strtotime($b['ban_date'])) ?></td>
                    <td>
                        <?php if ($b['is_permanent']): ?>
                        <span class="badge banned">دائم</span>
                        <?php else: ?>
                        <span class="badge" style="background:rgba(251,191,36,0.15);color:#fbbf24">مؤقت</span>
                        <?php endif; ?>
                    </td>
                    <td style="color:#666;font-size:12px">
                        <?= $b['ban_expires'] ? date('Y-m-d H:i', strtotime($b['ban_expires'])) : '∞' ?>
                    </td>
                    <td>
                        <button class="btn btn-green btn-sm" onclick="unbanDevice('<?= $b['device_id'] ?>')">رفع الحظر</button>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            </div>
            <?php endif; ?>
        </div>
    </div>

</div><!-- /container -->

<script>
// ============ Navigation ============
function showPage(name) {
    document.querySelectorAll('.page').forEach(p => p.classList.remove('active'));
    document.querySelectorAll('.nav button').forEach(b => b.classList.remove('active'));
    document.getElementById('page-' + name).classList.add('active');
    event.target.classList.add('active');
}

// ============ Chart ============
const ctx = document.getElementById('dailyChart');
if (ctx) {
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: <?= json_encode($days_labels) ?>,
            datasets: [{
                label: 'مستخدمون نشطون',
                data: <?= json_encode($days_data) ?>,
                borderColor: '#e94560',
                backgroundColor: 'rgba(233,69,96,0.1)',
                borderWidth: 2,
                fill: true,
                tension: 0.4,
                pointBackgroundColor: '#e94560',
                pointRadius: 5
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { labels: { color: '#aaa' } } },
            scales: {
                x: { ticks: { color: '#666' }, grid: { color: '#1a2a3a' } },
                y: { ticks: { color: '#666' }, grid: { color: '#1a2a3a' }, beginAtZero: true }
            }
        }
    });
}

// ============ Search ============
function filterUsers() {
    const q = document.getElementById('user-search').value.toLowerCase();
    document.querySelectorAll('#users-table tbody tr').forEach(row => {
        row.style.display = row.textContent.toLowerCase().includes(q) ? '' : 'none';
    });
}

// ============ Copy ============
function copyText(text) {
    navigator.clipboard.writeText(text).then(() => showAlert('تم نسخ: ' + text, 'success'));
}

// ============ Alert ============
function showAlert(msg, type) {
    const el = document.getElementById('alert-box');
    el.textContent = msg;
    el.className = 'alert ' + type;
    el.style.display = 'block';
    setTimeout(() => el.style.display = 'none', 4000);
}

// ============ Toggle Expiry ============
function toggleExpiry() {
    const perm = document.getElementById('ban-permanent').value;
    document.getElementById('expiry-group').style.display = perm === '0' ? 'block' : 'none';
}

// ============ Ban Device ============
function banDevice() {
    const device_id    = document.getElementById('ban-device-id').value.trim();
    const user_id      = document.getElementById('ban-user-id').value.trim();
    const reason       = document.getElementById('ban-reason').value.trim();
    const is_permanent = document.getElementById('ban-permanent').value;
    const ban_expires  = document.getElementById('ban-expires').value;

    if (!device_id) { showAlert('أدخل Device ID', 'error'); return; }

    fetch(location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ action: 'ban', device_id, user_id: user_id || null, reason, is_permanent: parseInt(is_permanent), ban_expires: ban_expires || null })
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            showAlert('✅ ' + data.message, 'success');
            document.getElementById('ban-device-id').value = '';
            setTimeout(() => location.reload(), 2000);
        } else {
            showAlert('❌ ' + data.message, 'error');
        }
    })
    .catch(() => showAlert('❌ خطأ في الاتصال', 'error'));
}

// ============ Quick Ban (from users table) ============
function quickBan(device_id, user_id, name) {
    const reason = prompt('سبب حظر ' + name + ':', 'مخالفة قواعد الاستخدام');
    if (reason === null) return;

    fetch(location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ action: 'ban', device_id, user_id, reason, is_permanent: 1 })
    })
    .then(r => r.json())
    .then(data => {
        showAlert(data.success ? '✅ تم الحظر' : '❌ ' + data.message, data.success ? 'success' : 'error');
        if (data.success) setTimeout(() => location.reload(), 2000);
    });
}

// ============ Unban ============
function unbanDevice(device_id) {
    if (!confirm('رفع الحظر عن: ' + device_id + '؟')) return;
    fetch(location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ action: 'unban', device_id })
    })
    .then(r => r.json())
    .then(data => {
        showAlert(data.success ? '✅ تم رفع الحظر' : '❌ ' + data.message, data.success ? 'success' : 'error');
        if (data.success) setTimeout(() => location.reload(), 2000);
    });
}

function unbanFromInput() {
    const device_id = document.getElementById('unban-device-id').value.trim();
    if (!device_id) { showAlert('أدخل Device ID', 'error'); return; }
    unbanDevice(device_id);
}
</script>
</body>
</html>
