<?php
/**
 * admin_shop_api.php - v4.0
 * رفع الصور من الهاتف + حفظ في avtar/
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, DELETE');
header('Access-Control-Allow-Headers: Content-Type');

error_reporting(E_ALL);
ini_set('display_errors', 0);

define('ADMIN_USER', 'admin');
define('ADMIN_PASS', 'admin123');

// مجلد الحفظ المحلي
define('UPLOAD_DIR',    __DIR__ . '/avtar/');
define('UPLOAD_URL',    'https://latrotech.online/Copel/avtar/');
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_TYPES', ['image/jpeg','image/png','image/gif','image/webp']);

if (!is_dir(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}

// checkAuth(); // أزل // لتفعيل الحماية

require_once 'db_connect.php';

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? $_POST['action'] ?? '';

if ($method === 'POST' && empty($_FILES)) {
    $input = json_decode(file_get_contents('php://input'), true);
    if ($input) {
        $_POST = array_merge($_POST, $input);
        $action = $input['action'] ?? $action;
    }
}

try {
    switch ($action) {
        case 'add':          addItem();     break;
        case 'upload_image': uploadImage(); break;
        case 'list':         listItems();   break;
        case 'delete':       deleteItem();  break;
        case 'stats':        getStats();    break;
        case 'update':       updateItem();  break;
        default: throw new Exception('Invalid action');
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
}

// ===========================
// رفع الصورة من الهاتف
// ===========================
function uploadImage() {
    if (!isset($_FILES['frame_image']) || $_FILES['frame_image']['error'] !== UPLOAD_ERR_OK) {
        $code = $_FILES['frame_image']['error'] ?? -1;
        throw new Exception('خطأ في رفع الملف: ' . getUploadError($code));
    }
    $file = $_FILES['frame_image'];

    if ($file['size'] > MAX_FILE_SIZE) {
        throw new Exception('حجم الملف كبير جداً! الحد الأقصى 5MB');
    }

    $finfo    = finfo_open(FILEINFO_MIME_TYPE);
    $mimeType = finfo_file($finfo, $file['tmp_name']);
    finfo_close($finfo);

    if (!in_array($mimeType, ALLOWED_TYPES)) {
        throw new Exception('نوع الملف غير مسموح! JPG, PNG, GIF, WebP فقط');
    }

    $extMap     = ['image/jpeg'=>'jpg','image/png'=>'png','image/gif'=>'gif','image/webp'=>'webp'];
    $extension  = $extMap[$mimeType] ?? 'jpg';
    $uniqueName = 'frame_' . uniqid() . '_' . time() . '.' . $extension;
    $uploadPath = UPLOAD_DIR . $uniqueName;

    if (!move_uploaded_file($file['tmp_name'], $uploadPath)) {
        throw new Exception('فشل في حفظ الصورة على السيرفر');
    }
    chmod($uploadPath, 0644);

    echo json_encode([
        'status'    => 'success',
        'message'   => 'تم رفع الصورة بنجاح ✅',
        'file_url'  => UPLOAD_URL . $uniqueName,
        'file_name' => $uniqueName
    ]);
}

// ===========================
// إضافة عنصر
// ===========================
function addItem() {
    global $conn;

    $required = ['item_type','item_name_ar','coins_required','level_required','rarity','unlock_type'];
    foreach ($required as $f) {
        if (!isset($_POST[$f]) || $_POST[$f] === '') throw new Exception("حقل $f مطلوب");
    }

    $itemType    = $_POST['item_type'];
    $identifier  = $_POST['item_identifier'] ?? '';
    $name        = $_POST['item_name'] ?? $_POST['item_name_ar'];
    $nameAr      = $_POST['item_name_ar'];
    $description = $_POST['item_description'] ?? null;
    $coinsReq    = (int)$_POST['coins_required'];
    $levelReq    = (int)$_POST['level_required'];
    $rarity      = $_POST['rarity'];
    $unlockType  = $_POST['unlock_type'];
    $previewUrl  = $_POST['item_preview_url'] ?? null;
    $baseUrl     = $_POST['base_url'] ?? UPLOAD_URL;
    $autoGen     = false;

    if (!in_array($itemType,['frame','font','color']))
        throw new Exception('نوع العنصر غير صحيح');
    if (!in_array($rarity,['common','rare','epic','legendary']))
        throw new Exception('الندرة غير صحيحة');
    if (!in_array($unlockType,['free','coins','level','both']))
        throw new Exception('نوع الفتح غير صحيح');
    if ($itemType === 'color' && !preg_match('/^gradient:wave:[A-Fa-f0-9,]+$/', $identifier))
        throw new Exception('صيغة التدرج غير صحيحة');

    if ($itemType === 'frame') {
        if (empty($identifier) || $identifier === 'auto') {
            $autoGen = true; $identifier = ''; $previewUrl = null;
        } elseif (filter_var($identifier, FILTER_VALIDATE_URL)) {
            $previewUrl = $identifier;
        }
    }

    if (!$autoGen && !empty($identifier)) {
        $s = $conn->prepare("SELECT id FROM shop_items WHERE item_identifier=:id");
        $s->execute([':id'=>$identifier]);
        if ($s->fetch()) throw new Exception('هذا المعرف موجود مسبقاً');
    }

    $s = $conn->prepare("SELECT MAX(sort_order) as mo FROM shop_items WHERE item_type=:t");
    $s->execute([':t'=>$itemType]);
    $sortOrder = ($s->fetch(PDO::FETCH_ASSOC)['mo'] ?? 0) + 1;
    $isPremium = ($rarity === 'legendary') ? 1 : 0;
    $category  = $itemType === 'color' ? 'gradients' : $itemType.'s';

    $s = $conn->prepare("
        INSERT INTO shop_items
            (item_type,item_identifier,item_name,item_name_ar,item_description,
             item_preview_url,unlock_type,coins_required,level_required,
             is_premium,category,rarity,is_active,sort_order)
        VALUES
            (:type,:identifier,:name,:name_ar,:desc,
             :preview,:unlock,:coins,:level,
             :prem,:cat,:rar,TRUE,:sort)
    ");
    $s->execute([
        ':type'=>$itemType,':identifier'=>$identifier,':name'=>$name,':name_ar'=>$nameAr,
        ':desc'=>$description,':preview'=>$previewUrl,':unlock'=>$unlockType,
        ':coins'=>$coinsReq,':level'=>$levelReq,':prem'=>$isPremium,
        ':cat'=>$category,':rar'=>$rarity,':sort'=>$sortOrder
    ]);
    $itemId = $conn->lastInsertId();

    if ($autoGen && $itemType === 'frame') {
        $autoUrl = rtrim($baseUrl,'/').'/frame_'.$itemId.'.png';
        $u = $conn->prepare("UPDATE shop_items SET item_identifier=:url,item_preview_url=:url WHERE id=:id");
        $u->execute([':url'=>$autoUrl,':id'=>$itemId]);
        $previewUrl = $autoUrl;
    }

    clearCache();
    echo json_encode(['status'=>'success','message'=>'تم إضافة العنصر بنجاح 🎉','item_id'=>$itemId,'preview_url'=>$previewUrl]);
}

// ===========================
// قائمة العناصر
// ===========================
function listItems() {
    global $conn;
    $type = $_GET['type'] ?? '';
    $sql  = "SELECT * FROM shop_items WHERE is_active=TRUE";
    if ($type && in_array($type,['frame','font','color'])) $sql .= " AND item_type=:type";
    $sql .= " ORDER BY CASE rarity WHEN 'legendary' THEN 1 WHEN 'epic' THEN 2 WHEN 'rare' THEN 3 ELSE 4 END, sort_order, id DESC";
    $s = $conn->prepare($sql);
    ($type && in_array($type,['frame','font','color'])) ? $s->execute([':type'=>$type]) : $s->execute();
    $items = $s->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['status'=>'success','items'=>$items,'count'=>count($items)]);
}

// ===========================
// حذف عنصر
// ===========================
function deleteItem() {
    global $conn;
    $itemId = $_POST['item_id'] ?? 0;
    if (!$itemId) throw new Exception('معرف العنصر مطلوب');
    $s = $conn->prepare("SELECT id,item_name_ar,item_preview_url FROM shop_items WHERE id=:id");
    $s->execute([':id'=>$itemId]);
    $item = $s->fetch(PDO::FETCH_ASSOC);
    if (!$item) throw new Exception('العنصر غير موجود');

    // حذف الصورة المرفوعة من السيرفر
    if (!empty($item['item_preview_url'])) {
        $fileName  = basename($item['item_preview_url']);
        $localFile = UPLOAD_DIR . $fileName;
        if (file_exists($localFile)) @unlink($localFile);
    }

    $s = $conn->prepare("UPDATE shop_items SET is_active=FALSE WHERE id=:id");
    $s->execute([':id'=>$itemId]);
    clearCache();
    echo json_encode(['status'=>'success','message'=>'تم حذف "'.$item['item_name_ar'].'" بنجاح 🗑️']);
}

// ===========================
// الإحصائيات
// ===========================
function getStats() {
    global $conn;
    $q = fn($sql) => (int)$conn->query($sql)->fetch(PDO::FETCH_ASSOC)['count'];
    echo json_encode(['status'=>'success','stats'=>[
        'total'  => $q("SELECT COUNT(*) as count FROM shop_items WHERE is_active=TRUE"),
        'frames' => $q("SELECT COUNT(*) as count FROM shop_items WHERE is_active=TRUE AND item_type='frame'"),
        'fonts'  => $q("SELECT COUNT(*) as count FROM shop_items WHERE is_active=TRUE AND item_type='font'"),
        'colors' => $q("SELECT COUNT(*) as count FROM shop_items WHERE is_active=TRUE AND item_type='color'"),
    ]]);
}

// ===========================
// تحديث عنصر
// ===========================
function updateItem() {
    global $conn;
    $itemId = $_POST['item_id'] ?? 0;
    if (!$itemId) throw new Exception('معرف العنصر مطلوب');
    $allowed = ['item_name','item_name_ar','item_description','item_preview_url',
                'coins_required','level_required','rarity','unlock_type','is_active','sort_order'];
    $updates = []; $params = [':id'=>$itemId];
    foreach ($allowed as $f) {
        if (isset($_POST[$f])) { $updates[] = "$f=:$f"; $params[":$f"]=$_POST[$f]; }
    }
    if (empty($updates)) throw new Exception('لا توجد حقول للتحديث');
    $conn->prepare("UPDATE shop_items SET ".implode(',',$updates)." WHERE id=:id")->execute($params);
    clearCache();
    echo json_encode(['status'=>'success','message'=>'تم التحديث بنجاح ✅']);
}

function clearCache() {
    if (function_exists('apcu_clear_cache')) apcu_clear_cache();
}

function getUploadError($code) {
    return [
        UPLOAD_ERR_INI_SIZE   => 'الملف أكبر من الحد المسموح',
        UPLOAD_ERR_FORM_SIZE  => 'الملف أكبر من حد النموذج',
        UPLOAD_ERR_PARTIAL    => 'رفع جزئي فقط',
        UPLOAD_ERR_NO_FILE    => 'لم يتم اختيار ملف',
        UPLOAD_ERR_NO_TMP_DIR => 'مجلد مؤقت غير موجود',
        UPLOAD_ERR_CANT_WRITE => 'فشل الكتابة على القرص',
    ][$code] ?? 'خطأ غير معروف';
}
?>