<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if($_SERVER['REQUEST_METHOD']==='OPTIONS') exit(0);

$servername="localhost"; $dbname="u323701002_coc";
$username="u323701002_us_coc"; $password="AS_05344465928pr";
try{
  $conn=new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8mb4",$username,$password);
  $conn->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
  $conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE,PDO::FETCH_ASSOC);
}catch(PDOException $e){
  http_response_code(500);
  exit(json_encode(['status'=>'error','message'=>'فشل الاتصال: '.$e->getMessage()]));
}

$action=$_GET['action']??'';

switch($action){

  case 'get_rooms':
    try{
      // جلب الغرف مع المالك
      $stmt=$conn->query("
        SELECT 
          cr.id, cr.name, cr.description, cr.image_url, cr.max_members, cr.created_at,
          COUNT(CASE WHEN rm.is_online=1 THEN 1 END) AS online_members,
          COUNT(rm.id) AS total_members,
          u.display_name AS owner_name,
          u.profile_image_url AS owner_image,
          u.id AS owner_id
        FROM chat_rooms cr
        LEFT JOIN room_members rm ON cr.id=rm.room_id
        LEFT JOIN room_members rm_owner ON cr.id=rm_owner.room_id AND rm_owner.role='owner'
        LEFT JOIN users u ON rm_owner.user_id=u.id
        GROUP BY cr.id, u.display_name, u.profile_image_url, u.id
        ORDER BY cr.created_at DESC
      ");
      $rooms=$stmt->fetchAll();
      echo json_encode(['status'=>'success','rooms'=>$rooms]);
    }catch(Exception $e){ http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  case 'add_room':
    $name=trim($_POST['name']??'');
    $description=trim($_POST['description']??'');
    $max_members=(int)($_POST['max_members']??50);
    $image_url='';
    if(empty($name)){ http_response_code(400); echo json_encode(['status'=>'error','message'=>'اسم الغرفة مطلوب']); break; }
    if(!empty($_FILES['image']['tmp_name'])){
      $file=$_FILES['image'];
      $ext=strtolower(pathinfo($file['name'],PATHINFO_EXTENSION));
      $allowed=['jpg','jpeg','png','gif','webp'];
      if(!in_array($ext,$allowed)){ http_response_code(400); echo json_encode(['status'=>'error','message'=>'صيغة غير مدعومة']); break; }
      if($file['size']>5*1024*1024){ http_response_code(400); echo json_encode(['status'=>'error','message'=>'الصورة أكبر من 5MB']); break; }
      $upload_dir=__DIR__.'/room/';
      if(!is_dir($upload_dir)) mkdir($upload_dir,0755,true);
      $filename='room_'.time().'_'.rand(1000,9999).'.'.$ext;
      $dest=$upload_dir.$filename;
      if(move_uploaded_file($file['tmp_name'],$dest)){
        $image_url='https://latrotech.online/Copel/room/'.$filename;
      }else{ http_response_code(500); echo json_encode(['status'=>'error','message'=>'فشل رفع الصورة']); break; }
    }
    try{
      $stmt=$conn->prepare("INSERT INTO chat_rooms (name,description,image_url,max_members,created_at) VALUES (:name,:description,:image_url,:max_members,NOW())");
      $stmt->execute([':name'=>$name,':description'=>$description,':image_url'=>$image_url,':max_members'=>$max_members]);
      echo json_encode(['status'=>'success','message'=>'تم إنشاء الغرفة','room_id'=>(int)$conn->lastInsertId(),'image_url'=>$image_url]);
    }catch(Exception $e){ http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  case 'delete_room':
    $data=json_decode(file_get_contents('php://input'),true);
    $roomId=(int)($data['room_id']??0);
    if($roomId<=0){ http_response_code(400); echo json_encode(['status'=>'error','message'=>'معرف الغرفة مطلوب']); break; }
    try{
      $conn->beginTransaction();
      $conn->prepare("DELETE FROM room_messages WHERE room_id=?")->execute([$roomId]);
      $conn->prepare("DELETE FROM room_members WHERE room_id=?")->execute([$roomId]);
      $conn->prepare("DELETE FROM room_banned_users WHERE room_id=?")->execute([$roomId]);
      $conn->prepare("DELETE FROM chat_rooms WHERE id=?")->execute([$roomId]);
      $conn->commit();
      echo json_encode(['status'=>'success','message'=>'تم حذف الغرفة']);
    }catch(Exception $e){ $conn->rollBack(); http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  case 'get_members':
    $roomId=(int)($_GET['room_id']??0);
    if($roomId<=0){ http_response_code(400); echo json_encode(['status'=>'error','message'=>'معرف الغرفة مطلوب']); break; }
    try{
      $stmt=$conn->prepare("
        SELECT rm.id,rm.user_id,rm.role,rm.is_online,rm.joined_at,
               u.display_name,u.profile_image_url,u.level,u.is_verified
        FROM room_members rm
        LEFT JOIN users u ON rm.user_id=u.id
        WHERE rm.room_id=:room_id
        ORDER BY FIELD(rm.role,'owner','admin','member'), rm.joined_at ASC
      ");
      $stmt->execute([':room_id'=>$roomId]);
      echo json_encode(['status'=>'success','members'=>$stmt->fetchAll()]);
    }catch(Exception $e){ http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  // ════ تغيير دور عضو (تعيين/إزالة أدمن) ════
  case 'change_role':
    $data=json_decode(file_get_contents('php://input'),true);
    $roomId=(int)($data['room_id']??0);
    $userId=(int)($data['user_id']??0);
    $newRole=$data['new_role']??'';
    if($roomId<=0||$userId<=0||!in_array($newRole,['admin','member'])){
      http_response_code(400);
      echo json_encode(['status'=>'error','message'=>'بيانات غير صحيحة']);
      break;
    }
    try{
      // تحقق أن المستخدم في الغرفة وليس المالك
      $stmt=$conn->prepare("SELECT role FROM room_members WHERE room_id=:r AND user_id=:u");
      $stmt->execute([':r'=>$roomId,':u'=>$userId]);
      $member=$stmt->fetch();
      if(!$member){ echo json_encode(['status'=>'error','message'=>'المستخدم ليس عضواً في الغرفة']); break; }
      if($member['role']==='owner'){ echo json_encode(['status'=>'error','message'=>'لا يمكن تغيير دور المالك']); break; }

      $stmt=$conn->prepare("UPDATE room_members SET role=:role WHERE room_id=:r AND user_id=:u");
      $stmt->execute([':role'=>$newRole,':r'=>$roomId,':u'=>$userId]);
      $lbl=$newRole==='admin'?'تم تعيين المشرف بنجاح':'تمت إزالة صلاحيات المشرف';
      echo json_encode(['status'=>'success','message'=>$lbl]);
    }catch(Exception $e){ http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  case 'get_banned_users':
    $roomId=(int)($_GET['room_id']??0);
    if($roomId<=0){ http_response_code(400); echo json_encode(['status'=>'error','message'=>'معرف الغرفة مطلوب']); break; }
    try{
      $stmt=$conn->prepare("
        SELECT rbu.id AS ban_id,rbu.user_id,rbu.room_id,rbu.banned_at,
               u.display_name,u.profile_image_url,u.level,cr.name AS room_name
        FROM room_banned_users rbu
        LEFT JOIN users u ON rbu.user_id=u.id
        LEFT JOIN chat_rooms cr ON rbu.room_id=cr.id
        WHERE rbu.room_id=:room_id ORDER BY rbu.banned_at DESC
      ");
      $stmt->execute([':room_id'=>$roomId]);
      echo json_encode(['status'=>'success','banned_users'=>$stmt->fetchAll()]);
    }catch(Exception $e){ http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  case 'get_all_banned':
    try{
      $stmt=$conn->query("
        SELECT rbu.id AS ban_id,rbu.user_id,rbu.room_id,rbu.banned_at,
               u.display_name,u.profile_image_url,u.level,cr.name AS room_name
        FROM room_banned_users rbu
        LEFT JOIN users u ON rbu.user_id=u.id
        LEFT JOIN chat_rooms cr ON rbu.room_id=cr.id
        ORDER BY rbu.banned_at DESC
      ");
      echo json_encode(['status'=>'success','banned_users'=>$stmt->fetchAll()]);
    }catch(Exception $e){ http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  case 'unban_user':
    $data=json_decode(file_get_contents('php://input'),true);
    $banId=(int)($data['ban_id']??0);
    $userId=(int)($data['user_id']??0);
    $roomId=(int)($data['room_id']??0);
    if($banId<=0&&($userId<=0||$roomId<=0)){ http_response_code(400); echo json_encode(['status'=>'error','message'=>'بيانات غير مكتملة']); break; }
    try{
      if($banId>0){ $stmt=$conn->prepare("DELETE FROM room_banned_users WHERE id=?"); $stmt->execute([$banId]); }
      else{ $stmt=$conn->prepare("DELETE FROM room_banned_users WHERE user_id=? AND room_id=?"); $stmt->execute([$userId,$roomId]); }
      if($stmt->rowCount()>0) echo json_encode(['status'=>'success','message'=>'تم رفع الحظر بنجاح']);
      else{ http_response_code(404); echo json_encode(['status'=>'error','message'=>'لم يتم العثور على سجل الحظر']); }
    }catch(Exception $e){ http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  case 'get_stats':
    try{
      $totalRooms=$conn->query("SELECT COUNT(*) FROM chat_rooms")->fetchColumn();
      $totalOnline=$conn->query("SELECT COUNT(*) FROM room_members WHERE is_online=1")->fetchColumn();
      $totalBanned=$conn->query("SELECT COUNT(*) FROM room_banned_users")->fetchColumn();
      $totalMembers=$conn->query("SELECT COUNT(*) FROM room_members")->fetchColumn();
      echo json_encode(['status'=>'success','total_rooms'=>(int)$totalRooms,'online_now'=>(int)$totalOnline,'total_banned'=>(int)$totalBanned,'total_members'=>(int)$totalMembers]);
    }catch(Exception $e){ http_response_code(500); echo json_encode(['status'=>'error','message'=>$e->getMessage()]); }
    break;

  default:
    http_response_code(400);
    echo json_encode(['status'=>'error','message'=>'action غير معرف: '.$action]);
}
?>