<?php
ob_start();
header('Content-Type: application/json; charset=utf-8');

error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

require 'db_connect.php';

$rewardsEnabled = false;
$useNewRewardSystem = false;

if (file_exists('points_manager_v2.php')) {
    try {
        require 'points_manager_v2.php';
        $useNewRewardSystem = function_exists('grantRewardV2');
        $rewardsEnabled = true;
    } catch (Exception $e) {
        error_log("Failed to load points_manager_v2.php: " . $e->getMessage());
    }
}

if (!$rewardsEnabled && file_exists('points_manager.php')) {
    try {
        require 'points_manager.php';
        $rewardsEnabled = function_exists('grantReward');
    } catch (Exception $e) {
        error_log("Failed to load points_manager.php: " . $e->getMessage());
    }
}

function respond_json($payload, $httpCode = 200) {
    http_response_code($httpCode);

    // امسح أي output انطبع بالخطأ قبل الرد
    $garbage = ob_get_clean();
    if (!empty($garbage)) {
        error_log("Non-JSON output captured: " . $garbage);
    }

    echo json_encode($payload, JSON_UNESCAPED_UNICODE);
    exit;
}

$input_data = [];
if (!empty($_POST)) {
    $input_data = $_POST;
} else {
    $json_payload = file_get_contents('php://input');
    $decoded_data = json_decode($json_payload, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        $input_data = $decoded_data;
    }
}

if (empty($input_data['user_id']) || empty($input_data['title']) || empty($input_data['memory_date'])) {
    respond_json(['status' => 'error', 'message' => 'Missing required fields.'], 400);
}

$user_id = $input_data['user_id'];
$title = $input_data['title'];
$memory_date = $input_data['memory_date'];
$description = $input_data['description'] ?? null;
$emoji = $input_data['emoji'] ?? null;
$image_url = null;

try {
    $stmt_couple = $conn->prepare("SELECT couple_id FROM users WHERE id = :user_id");
    $stmt_couple->execute([':user_id' => $user_id]);
    $user_data = $stmt_couple->fetch(PDO::FETCH_ASSOC);

    if (!$user_data || empty($user_data['couple_id'])) {
        throw new Exception("User is not part of a couple.");
    }
    $couple_id = $user_data['couple_id'];

    if (isset($_FILES['memory_image']) && $_FILES['memory_image']['error'] === UPLOAD_ERR_OK) {
        $upload_dir = 'uploads/memories/';
        $base_url = 'https://latrotech.online/Copel/';

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        $image_file = $_FILES['memory_image'];
        $file_extension = pathinfo($image_file['name'], PATHINFO_EXTENSION);
        $safe_extension = strtolower(in_array(strtolower($file_extension), ['jpg', 'jpeg', 'png', 'gif']) ? $file_extension : 'jpg');

        $file_name = 'memory_' . $couple_id . '_' . time() . '.' . $safe_extension;
        $target_path = $upload_dir . $file_name;

        if (move_uploaded_file($image_file['tmp_name'], $target_path)) {
            $image_url = $base_url . $target_path;
        }
    }

    $stmt_insert = $conn->prepare(
        "INSERT INTO memories (couple_id, title, description, emoji, memory_date, image_url) 
         VALUES (:couple_id, :title, :description, :emoji, :memory_date, :image_url)"
    );
    $stmt_insert->execute([
        ':couple_id' => $couple_id,
        ':title' => $title,
        ':description' => $description,
        ':emoji' => $emoji,
        ':memory_date' => $memory_date,
        ':image_url' => $image_url
    ]);

    $memoryId = $conn->lastInsertId();

    $stmt_select = $conn->prepare("SELECT * FROM memories WHERE id = :id");
    $stmt_select->execute([':id' => $memoryId]);
    $new_memory = $stmt_select->fetch(PDO::FETCH_ASSOC);

    $rewardResult = null;
    $rewardGranted = false;

    if ($rewardsEnabled) {
        try {
            if ($useNewRewardSystem) {
                $today = date('Y-m-d');
                $stmt_check = $conn->prepare(
                    "SELECT COUNT(*) as count 
                     FROM daily_actions_log 
                     WHERE user_id = :uid 
                     AND action_type = 'add_memory' 
                     AND DATE(action_date) = :today"
                );
                $stmt_check->execute([':uid' => $user_id, ':today' => $today]);
                $result = $stmt_check->fetch(PDO::FETCH_ASSOC);
                $countToday = (int)($result['count'] ?? 0);

                if ($countToday < 1) {
                    $rewardResult = grantRewardV2($conn, $user_id, 'add_memory');
                    $rewardGranted = true;
                } else {
                    $rewardResult = [
                        'status' => 'limit_reached',
                        'coins_earned' => 0,
                        'xp_earned' => 0,
                        'count_today' => $countToday,
                        'daily_limit' => 1
                    ];
                }
            } else {
                $stmt_check_col = $conn->prepare("SHOW COLUMNS FROM users LIKE 'coins'");
                $stmt_check_col->execute();
                $column_exists = $stmt_check_col->fetch(PDO::FETCH_ASSOC);

                if ($column_exists) {
                    $rewardResult = grantReward($conn, $user_id, 'add_memory');
                    $rewardGranted = true;
                } else {
                    error_log('Warning: coins column does not exist');
                    $rewardResult = [
                        'status' => 'skipped',
                        'coins_earned' => 0,
                        'xp_earned' => 0
                    ];
                }
            }
        } catch (Exception $reward_error) {
            error_log('Reward Error: ' . $reward_error->getMessage());
            $rewardResult = [
                'status' => 'error',
                'coins_earned' => 0,
                'xp_earned' => 0
            ];
        }
    } else {
        $rewardResult = [
            'status' => 'disabled',
            'coins_earned' => 0,
            'xp_earned' => 0
        ];
    }

    respond_json([
        'status' => 'success',
        'data' => [
            'memory' => $new_memory,
            'reward' => $rewardResult,
            'reward_granted' => $rewardGranted
        ]
    ], 200);

} catch (Exception $e) {
    error_log('Add Memory Error: ' . $e->getMessage());
    respond_json([
        'status' => 'error',
        'message' => 'خطأ في السيرفر: ' . $e->getMessage()
    ], 500);
}
