<?php
/**
 * activate_vip.php
 * ================
 * تفعيل اشتراك VIP لمستخدم
 * POST: { user_id, tier, months }
 */
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data   = json_decode(file_get_contents('php://input'), true);
$userId = isset($data['user_id']) ? (int)$data['user_id'] : 0;
$tier   = $data['tier']   ?? '';
$months = isset($data['months']) ? (int)$data['months'] : 1;

$allowedTiers = ['basic', 'silver', 'gold'];

if (!$userId || !in_array($tier, $allowedTiers)) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'بيانات غير صحيحة']));
}

if ($months < 1 || $months > 12) $months = 1;

try {
    // التحقق من وجود المستخدم
    $check = $conn->prepare("SELECT id FROM users WHERE id = :id");
    $check->execute([':id' => $userId]);
    if (!$check->fetch()) {
        exit(json_encode(['status' => 'error', 'message' => 'المستخدم غير موجود']));
    }

    // إذا كان لديه اشتراك نشط → نمدده، وإلا نبدأ من الآن
    $current = $conn->prepare("SELECT vip_tier, vip_expires_at FROM users WHERE id = :id");
    $current->execute([':id' => $userId]);
    $row = $current->fetch();

    $baseDate = 'now';
    if ($row && $row['vip_tier'] !== 'none' && $row['vip_expires_at']
        && strtotime($row['vip_expires_at']) > time()) {
        // لديه اشتراك نشط → امتداد من تاريخ الانتهاء الحالي
        $baseDate = $row['vip_expires_at'];
    }

    $expiresAt = date('Y-m-d H:i:s', strtotime("+{$months} months", strtotime($baseDate)));

    $stmt = $conn->prepare(
        "UPDATE users SET vip_tier = :tier, vip_expires_at = :expires WHERE id = :id"
    );
    $stmt->execute([':tier' => $tier, ':expires' => $expiresAt, ':id' => $userId]);

    echo json_encode([
        'status'     => 'success',
        'message'    => 'تم تفعيل VIP بنجاح',
        'tier'       => $tier,
        'expires_at' => $expiresAt
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>