<?php
// PusherHelper.php (Clean Version)

function send_pusher_trigger($auth_key, $secret, $app_id, $cluster, $channel, $event, $data, $socket_id = null) {
    $host = "api-{$cluster}.pusher.com";
    $path = "/apps/{$app_id}/events";
    
    $body_array = [
        'name' => $event,
        'channel' => $channel,
        'data' => json_encode($data)
    ];

    if ($socket_id !== null) {
        $body_array['socket_id'] = $socket_id;
    }

    $body = json_encode($body_array);

    $query_params = [
        'auth_key' => $auth_key,
        'auth_timestamp' => time(),
        'auth_version' => '1.0',
        'body_md5' => md5($body)
    ];
    
    ksort($query_params);
    
    $string_to_sign = "POST\n{$path}\n" . http_build_query($query_params);
    
    $auth_signature = hash_hmac('sha256', $string_to_sign, $secret);
    
    $query_params['auth_signature'] = $auth_signature;
    
    $query_string = http_build_query($query_params);
    
    $url = "https://{$host}{$path}?{$query_string}";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($body)
    ]);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($http_code === 200) {
        return true;
    } else {
        error_log("Pusher Error: HTTP {$http_code} - Response: {$response} - cURL Error: {$error}");
        return false;
    }
}